/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.sql.method;

import cn.com.yusys.yusp.commons.mapper.constant.SqlMethodEnum;
import cn.com.yusys.yusp.commons.mapper.exception.YuMapperException;
import cn.com.yusys.yusp.commons.mapper.sql.entity.KeyEntityColumn;
import cn.com.yusys.yusp.commons.mapper.sql.method.SqlMethod;
import cn.com.yusys.yusp.commons.mapper.util.MapperUtils;
import cn.com.yusys.yusp.commons.mapper.util.SqlUtils;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tk.mybatis.mapper.entity.Config;
import tk.mybatis.mapper.entity.EntityTable;

public abstract class AbstractSqlMethod
implements SqlMethod {
    private static final Logger log = LoggerFactory.getLogger(AbstractSqlMethod.class);
    protected MapperBuilderAssistant builderAssistant;
    protected Configuration configuration;
    protected LanguageDriver languageDriver;

    @Override
    public void inject(MapperBuilderAssistant assistant, EntityTable entityTable, Config config) throws YuMapperException {
        this.builderAssistant = assistant;
        this.configuration = assistant.getConfiguration();
        this.languageDriver = this.configuration.getDefaultScriptingLanguageInstance();
        this.injectMappedStatement(entityTable, config);
    }

    public abstract MappedStatement injectMappedStatement(EntityTable var1, Config var2) throws YuMapperException;

    protected MappedStatement addSelectMappedStatementForTable(EntityTable table, String method, SqlSource sqlSource) {
        ResultMap resultMap = table.getResultMap(this.configuration);
        if (null != resultMap) {
            this.addResultMap(table, this.configuration);
            return this.addMappedStatement(table.getEntityClass(), method, sqlSource, SqlCommandType.SELECT, null, resultMap.getId(), null, (KeyGenerator)new NoKeyGenerator(), null, null);
        }
        return this.addSelectMappedStatementForOther(table.getEntityClass(), method, sqlSource, table.getEntityClass());
    }

    protected void addResultMap(EntityTable entityTable, Configuration configuration) {
        ResultMap resultMap = entityTable.getResultMap(configuration);
        String id = entityTable.getEntityClass().getName() + "." + resultMap.getId();
        if (configuration.hasResultMap(id)) {
            return;
        }
        ResultMap.Builder builder = new ResultMap.Builder(configuration, id, entityTable.getEntityClass(), resultMap.getResultMappings(), Boolean.valueOf(true));
        configuration.addResultMap(builder.build());
    }

    protected MappedStatement addSelectMappedStatementForOther(Class<?> entityClass, String method, SqlSource sqlSource, Class<?> resultType) {
        return this.addMappedStatement(entityClass, method, sqlSource, SqlCommandType.SELECT, null, null, resultType, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    protected MappedStatement addInsertMappedStatement(Class<?> entityClass, Class<?> parameterType, String method, SqlSource sqlSource, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        return this.addMappedStatement(entityClass, method, sqlSource, SqlCommandType.INSERT, parameterType, null, Integer.class, keyGenerator, keyProperty, keyColumn);
    }

    protected MappedStatement addInsertMappedStatement(EntityTable entityTable, Config config, SqlMethodEnum sqlMethodEnum, String entityName, boolean notNull, boolean notEmpty) throws YuMapperException {
        Class entityClass = entityTable.getEntityClass();
        StringBuilder key = new StringBuilder();
        KeyEntityColumn keyEntityColumn = SqlUtils.processKey(key, this.configuration, entityTable, config, "insert");
        String keyProperty = null;
        String keyColumn = null;
        if (keyEntityColumn.getEntityColumn() != null) {
            keyProperty = keyEntityColumn.getEntityColumn().getProperty();
            keyColumn = keyEntityColumn.getEntityColumn().getColumn();
        }
        String sql = String.format(sqlMethodEnum.getTemplate(), key.toString(), SqlUtils.tableName(entityTable, config), SqlUtils.insertColumns((Class)entityClass, (boolean)false, (boolean)notNull, (boolean)notEmpty), SqlUtils.insertValues(entityTable, config, entityName, notNull));
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, entityClass);
        log.info("{}:{}", (Object)this.getName(), (Object)sql);
        return this.addInsertMappedStatement(entityClass, entityClass, this.getName(), sqlSource, keyEntityColumn.getKeyGenerator(), keyProperty, keyColumn);
    }

    protected MappedStatement addUpdateMappedStatement(Class<?> entityClass, Class<?> parameterType, String method, SqlSource sqlSource) {
        return this.addMappedStatement(entityClass, method, sqlSource, SqlCommandType.UPDATE, parameterType, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    protected MappedStatement addDeleteMappedStatement(Class<?> entityClass, String method, String sql, Class<?> parameterType) {
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, parameterType);
        return this.addMappedStatement(entityClass, method, sqlSource, SqlCommandType.DELETE, null, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    protected MappedStatement addDeleteMappedStatement(Class<?> entityClass, String method, SqlSource sqlSource) {
        return this.addMappedStatement(entityClass, method, sqlSource, SqlCommandType.DELETE, null, null, Integer.class, (KeyGenerator)new NoKeyGenerator(), null, null);
    }

    protected synchronized MappedStatement addMappedStatement(Class<?> entityClass, String method, SqlSource sqlSource, SqlCommandType sqlCommandType, Class<?> parameterType, String resultMap, Class<?> resultType, KeyGenerator keyGenerator, String keyProperty, String keyColumn) {
        String statementName = MapperUtils.getSqlId(entityClass, method);
        if (this.hasMappedStatement(statementName)) {
            log.debug("{} has exists in Configuration, no need to generate", (Object)statementName);
            return null;
        }
        boolean isSelect = false;
        if (sqlCommandType == SqlCommandType.SELECT) {
            isSelect = true;
        }
        return this.builderAssistant.addMappedStatement(method, sqlSource, StatementType.PREPARED, sqlCommandType, null, null, null, parameterType, resultMap, resultType, null, !isSelect, isSelect, false, keyGenerator, keyProperty, keyColumn, this.configuration.getDatabaseId(), this.languageDriver, null);
    }

    private boolean hasMappedStatement(String mappedStatement) {
        return this.configuration.hasStatement(mappedStatement, false);
    }
}

