/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.key.generator;

import cn.com.yusys.yusp.commons.mapper.exception.YuMapperException;
import cn.com.yusys.yusp.commons.mapper.key.generator.KeyGenerator;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractKeyGenerator
implements KeyGenerator {
    @Override
    public void generate(Object target, Class<?> entityClass, Field field) throws YuMapperException {
        if (Map.class.isAssignableFrom(target.getClass())) {
            this.handleMapTarget((Map)target, entityClass, field);
        } else if (List.class.isAssignableFrom(target.getClass())) {
            this.handleListTarget((List)target, entityClass, field);
        } else {
            this.handleObjectTarget(target, entityClass, field);
        }
    }

    public abstract Number numberId(Object var1, Class<?> var2, Field var3);

    public abstract String stringId(Object var1, Class<?> var2, Field var3);

    protected void handleMapTarget(Map<Object, Object> targetMap, Class<?> entityClass, Field field) {
        Object value = targetMap.get(field.getName());
        if (Objects.isNull(value)) {
            if (Number.class.isAssignableFrom(field.getType())) {
                Number keyValue = this.numberId(targetMap, entityClass, field);
                targetMap.put(field.getName(), AbstractKeyGenerator.numberConvert(entityClass, field, keyValue));
            } else if (String.class.isAssignableFrom(field.getType())) {
                String keyValue = this.stringId(targetMap, entityClass, field);
                targetMap.put(field.getName(), keyValue);
            } else {
                throw new YuMapperException(String.format("Entity:%s Primary key field:%s Only supports number type and string type", entityClass, field.getName()));
            }
        }
    }

    protected void handleListTarget(List<?> targetList, Class<?> entityClass, Field field) {
        for (Object target : targetList) {
            if (Map.class.isAssignableFrom(target.getClass())) {
                this.handleMapTarget((Map)target, entityClass, field);
                continue;
            }
            this.handleObjectTarget(target, entityClass, field);
        }
    }

    protected void handleObjectTarget(Object target, Class<?> entityClass, Field field) {
        Field targetField;
        Field field2 = targetField = entityClass.equals(target.getClass()) ? field : ReflectionUtils.getDeclaredField((Object)target, (String)field.getName());
        if (Objects.isNull(targetField)) {
            return;
        }
        Object value = ReflectionUtils.getPropertyValue((Object)target, (Field)targetField);
        if (Objects.isNull(value)) {
            if (Number.class.isAssignableFrom(targetField.getType())) {
                Number keyValue = this.numberId(target, entityClass, targetField);
                ReflectionUtils.setPropertyValue((Object)target, (Field)targetField, (Object)AbstractKeyGenerator.numberConvert(entityClass, targetField, keyValue));
            } else if (String.class.isAssignableFrom(targetField.getType())) {
                String keyValue = this.stringId(target, entityClass, targetField);
                ReflectionUtils.setPropertyValue((Object)target, (Field)targetField, (Object)keyValue);
            } else {
                throw new YuMapperException(String.format("Entity:%s Primary key field:%s Only supports number type and string type", entityClass, targetField.getName()));
            }
        }
    }

    private static Object numberConvert(Class<?> entityClass, Field field, Object value) {
        BigDecimal bigDecimal = new BigDecimal(StringUtils.replaceObjNull((Object)value));
        if (Long.class.isAssignableFrom(field.getType()) || Long.TYPE.isAssignableFrom(field.getType())) {
            value = bigDecimal.longValue();
        } else if (Double.class.isAssignableFrom(field.getType()) || Double.TYPE.isAssignableFrom(field.getType())) {
            value = bigDecimal.doubleValue();
        } else if (Float.class.isAssignableFrom(field.getType()) || Float.TYPE.isAssignableFrom(field.getType())) {
            value = Float.valueOf(bigDecimal.floatValue());
        } else if (Integer.class.isAssignableFrom(field.getType()) || Integer.TYPE.isAssignableFrom(field.getType())) {
            value = bigDecimal.intValue();
        } else if (BigInteger.class.isAssignableFrom(field.getType())) {
            value = new BigInteger(bigDecimal.toString());
        } else if (!BigDecimal.class.isAssignableFrom(field.getType())) {
            throw new YuMapperException(String.format("Entity:%s Primary key field:%s The supported types are:%s", entityClass, field.getName(), "int, Integer, long, Long, double, Double, float, Float, BigDecimal, BigInteger"));
        }
        return value;
    }
}

