/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.executor;

import cn.com.yusys.yusp.commons.data.model.PageResult;
import cn.com.yusys.yusp.commons.data.query.Pageable;
import cn.com.yusys.yusp.commons.data.query.Sort;
import cn.com.yusys.yusp.commons.mapper.executor.SqlExecutor;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.util.ClassUtils;

public class SqlSessionExecutor
implements SqlExecutor {
    private final String sqlTemplate = "org.mybatis.spring.SqlSessionTemplate";
    private SqlSession sqlSessionProxy;
    private SqlSessionFactory sqlSessionFactory;
    private int batchSize = 1000;

    public SqlSessionExecutor(SqlSession sqlSessionProxy) {
        this.sqlSessionProxy = sqlSessionProxy;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    @Override
    public <T> List<T> select(String statement, Object record) {
        return this.sqlSessionProxy.selectList(statement, record);
    }

    public <T> PageResult<T> page(String statement, Object record, Pageable pageable) {
        List<T> result;
        if (pageable != null) {
            if (null != pageable.getSort() && !Objects.equals(pageable.getSort(), Sort.unSorted())) {
                PageHelper.startPage((int)pageable.getPage(), (int)pageable.getSize(), (String)pageable.getSort().getOrderBy());
            } else {
                PageHelper.startPage((int)pageable.getPage(), (int)pageable.getSize());
            }
        }
        if ((result = this.select(statement, record)) instanceof Page) {
            return new PageResult(((Page)result).getTotal(), ((Page)result).getPages(), ((Page)result).getResult());
        }
        return new PageResult<T>(result);
    }

    @Override
    public <T> int insert(String statement, Object record) {
        return this.sqlSessionProxy.insert(statement, record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int insertBatch(String statement, List<T> recordList, boolean trans) {
        int i = 0;
        if (trans || !ClassUtils.isPresent((String)"org.mybatis.spring.SqlSessionTemplate", null)) {
            SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            try {
                for (T record : recordList) {
                    session.insert(statement, record);
                    if (i % this.batchSize == 0 || i == recordList.size() - 1) {
                        session.commit();
                        session.clearCache();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                session.rollback();
            }
            finally {
                session.commit();
                session.close();
            }
        } else {
            SqlSessionTemplate sqlSessionTemplate = new SqlSessionTemplate(this.sqlSessionFactory, ExecutorType.BATCH);
            for (T record : recordList) {
                sqlSessionTemplate.insert(statement, record);
                ++i;
            }
        }
        return i;
    }

    @Override
    public <T> int update(String statement, Object record) {
        return this.sqlSessionProxy.update(statement, record);
    }

    @Override
    public <T> int delete(String statement, Object record) {
        return this.sqlSessionProxy.delete(statement, record);
    }

    @Override
    public <T> T selectById(String statement, Serializable id) {
        return (T)this.sqlSessionProxy.selectOne(statement, (Object)id);
    }

    @Override
    public int selectCount(String statement, Object record) {
        return (Integer)this.sqlSessionProxy.selectOne(statement, record);
    }
}

