/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.data.query;

import cn.com.yusys.yusp.commons.data.query.DirectionEnum;
import cn.com.yusys.yusp.commons.data.query.OrderItem;
import cn.com.yusys.yusp.commons.data.query.Sortable;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class Sort
implements Sortable {
    private static final Sort UNSORTED = Sort.by(new OrderItem());
    private List<OrderItem> orders;
    private String orderBy;

    public Sort(OrderItem ... orders) {
        this(Arrays.asList(orders));
    }

    public Sort(String orderBy) {
        this.orderBy = orderBy;
    }

    public Sort(List<OrderItem> orders) {
        Assert.notNull(orders, (String)"Orders must not be null!");
        this.orders = Collections.unmodifiableList(orders);
    }

    @Override
    public String getOrderBy() {
        if (StringUtils.nonEmpty((CharSequence)this.orderBy)) {
            return this.orderBy;
        }
        if (Objects.nonNull(this.orders) && !this.orders.isEmpty()) {
            return Sort.orderBy(this.orders);
        }
        return "";
    }

    public void append(String orderBy) {
    }

    public void append(OrderItem orderItem) {
    }

    public void append(DirectionEnum direction, String ... properties) {
    }

    public static String orderBy(List<OrderItem> orders) {
        StringBuilder orderBy = new StringBuilder();
        if (Objects.nonNull(orders) && !orders.isEmpty()) {
            orders.forEach(orderItem -> orderBy.append(orderItem.getColumn()).append(" ").append(orderItem.direction()).append(",").append(" "));
        }
        orderBy.delete(orderBy.length() - 2, orderBy.length()).append(" ");
        return orderBy.toString();
    }

    public static Sort by(DirectionEnum direction, String ... properties) {
        Assert.notNull((Object)((Object)direction), (String)"Direction must not be null!");
        Assert.notNull((Object)properties, (String)"Properties must not be null!");
        Assert.isTrue((properties.length > 0 ? 1 : 0) != 0, (String)"At least one property must be given!");
        return Sort.by(Arrays.stream(properties).map(it -> new OrderItem((String)it, direction.isAsc())).collect(Collectors.toList()));
    }

    public static Sort by(String orderBy) {
        return new Sort(orderBy);
    }

    public static Sort unSorted() {
        return UNSORTED;
    }

    public static Sort by(OrderItem ... orders) {
        Assert.notNull((Object)orders, (String)"Orders must not be null!");
        return new Sort(orders);
    }

    public static Sort by(List<OrderItem> orders) {
        Assert.notNull(orders, (String)"Orders must not be null!");
        return orders.isEmpty() ? Sort.unSorted() : new Sort(orders);
    }
}

