/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.swagger.gateway.web.rest;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class GatewaySwaggerResource {
    private static final Logger log = LoggerFactory.getLogger(GatewaySwaggerResource.class);
    private final DiscoveryClient discoveryClient;

    public GatewaySwaggerResource(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    @GetMapping(value={"/api/routes"})
    public List<ServiceInstance> findInstanceByServiceId(@RequestParam(required=false) String serviceId) {
        log.debug("fetch service :{} instance list", (Object)serviceId);
        if (StringUtils.isEmpty((CharSequence)serviceId)) {
            CopyOnWriteArrayList<ServiceInstance> allInstances = new CopyOnWriteArrayList<ServiceInstance>();
            this.discoveryClient.getServices().forEach(service -> allInstances.addAll(this.discoveryClient.getInstances(service)));
            return allInstances;
        }
        return this.discoveryClient.getInstances(serviceId);
    }
}

