/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.swagger.gateway;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

public class GatewaySwaggerResourcesProvider
implements SwaggerResourcesProvider {
    private static final Logger logger = LoggerFactory.getLogger(GatewaySwaggerResourcesProvider.class);
    private final String serviceId;
    private final RouteDefinitionLocator locator;

    public GatewaySwaggerResourcesProvider(String serviceId, RouteDefinitionLocator locator) {
        this.serviceId = serviceId;
        this.locator = locator;
    }

    public List<SwaggerResource> get() {
        try {
            return CompletableFuture.supplyAsync(() -> {
                ArrayList swaggerResources = new ArrayList();
                this.locator.getRouteDefinitions().toStream().filter(route -> !StringUtils.equals((CharSequence)this.routeId((RouteDefinition)route), (CharSequence)this.serviceId)).forEach(route -> {
                    Optional<PredicateDefinition> optional = route.getPredicates().stream().filter(predicateDefinition -> "Path".equals(predicateDefinition.getName())).findFirst();
                    if (optional.isPresent()) {
                        String routeId = this.routeId((RouteDefinition)route);
                        PredicateDefinition predicate = optional.get();
                        Map args = predicate.getArgs();
                        String pattern = (String)args.get("pattern");
                        if (pattern == null) {
                            pattern = (String)args.get("_genkey_0");
                        }
                        if (pattern != null) {
                            String location = StringUtils.replace((String)pattern, (String)"/**", (String)"/v2/api-docs");
                            swaggerResources.add(this.swaggerResource(routeId, location));
                        }
                    }
                });
                return swaggerResources;
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private String routeId(RouteDefinition routeDefinition) {
        return Optional.of(routeDefinition.getId()).map(x -> StringUtils.removeStart((String)x, (String)"CompositeDiscoveryClient_")).map(x -> StringUtils.removeStart((String)x, (String)"ReactiveCompositeDiscoveryClient_")).orElse(null);
    }

    private SwaggerResource swaggerResource(String name, String location) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setSwaggerVersion("2.0");
        swaggerResource.setLocation(location);
        return swaggerResource;
    }
}

