/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.swagger.gateway;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;

@Order(value=-2147483638)
public class GatewayHostPortPreferRule
implements IRule {
    private ILoadBalancer loadBalancer;
    private static final String INSTANCE_HEADER = "instance-prefer";

    public Server choose(Object key) {
        if (!(key instanceof ServerHttpRequest)) {
            return null;
        }
        ServerHttpRequest request = (ServerHttpRequest)key;
        List servers = this.loadBalancer.getAllServers();
        String hostPort = request.getHeaders().getFirst(INSTANCE_HEADER);
        if (StringUtils.isEmpty((CharSequence)hostPort)) {
            return null;
        }
        return servers.stream().filter(server -> StringUtils.equals((CharSequence)server.getHostPort(), (CharSequence)hostPort)).findFirst().orElse(null);
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        this.loadBalancer = lb;
    }

    public ILoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }
}

