/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.configuration;

import cn.com.yusys.yusp.commons.redis.EnhanceRedisCacheManager;
import cn.com.yusys.yusp.commons.redis.EnhanceRedisCacheWriter;
import cn.com.yusys.yusp.commons.redis.EnvAwareCacheResolver;
import cn.com.yusys.yusp.commons.redis.RedisCacheEnhanceManager;
import cn.com.yusys.yusp.commons.redis.template.EnhanceRedisTemplate;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Duration;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableCaching
@ConditionalOnClass(value={RedisConnectionFactory.class, EnhanceRedisCacheManager.class, EnhanceRedisTemplate.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.cache.type"}, havingValue="redis")
public class EnhanceRedisAutoConfiguration {
    @Value(value="${yusp.cache.ttl:720}")
    private int ttl;
    private static final Logger logger = LoggerFactory.getLogger(EnhanceRedisAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    @ConditionalOnMissingBean
    public CacheManager cacheManager(RedisConnectionFactory factory) {
        Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer = this.getJackson2JsonRedisSerializer();
        RedisCacheConfiguration cacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(name -> name + ":").serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(jackson2JsonRedisSerializer)).entryTtl(Duration.ofMinutes(this.ttl));
        logger.info("Auto configuration >> cache serialize configuration completed");
        RedisCacheEnhanceManager cacheManager = new RedisCacheEnhanceManager((RedisCacheWriter)new EnhanceRedisCacheWriter(factory), cacheConfiguration, new LinkedHashMap());
        cacheManager.setTransactionAware(true);
        return cacheManager;
    }

    @Bean
    public CacheResolver envCacheResolver(CacheManager cacheManager) {
        return new EnvAwareCacheResolver(cacheManager);
    }

    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer = this.getJackson2JsonRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer(jackson2JsonRedisSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setHashValueSerializer(jackson2JsonRedisSerializer);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    private Jackson2JsonRedisSerializer<Object> getJackson2JsonRedisSerializer() {
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.registerModule((Module)new JavaTimeModule());
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        return jackson2JsonRedisSerializer;
    }

    @Bean
    @ConditionalOnBean(value={RedisTemplate.class})
    public EnhanceRedisTemplate enhanceRedisTemplate() {
        return new EnhanceRedisTemplate();
    }
}

