/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv;

import cn.com.yusys.yusp.commons.excelcsv.async.ExportPostProcessor;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import java.io.File;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExportPostProcessor
implements ExportPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(FileExportPostProcessor.class);
    public static final FileExportPostProcessor FILE_EXPORT_POST_PROCESSOR = new FileExportPostProcessor();

    public String postProcessor(File file) {
        FileInfo fileInfo = FileExportPostProcessor.uploadTmpFile(file);
        String fileId = FileInfoUtils.toIdentity((FileInfo)fileInfo);
        logger.info("Upload success after get file id is:{}", (Object)fileId);
        return fileId;
    }

    public static FileInfo uploadTmpFile(File tempFile) {
        String dateDir = LocalDate.now().format(DateTimeFormatter.ofPattern(DateFormatEnum.DATE_COMPACT.getValue()));
        return FileInfoUtils.temporaryFileSystemTemplate().upload(tempFile, dateDir);
    }
}

