/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.shardingjdbc.ext.mybatis;

import cn.com.yusys.yusp.commons.shardingjdbc.ext.DataSourceRoutePropertiesDto;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.DataSourceRouteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataSourceNameInterceptor
implements Interceptor {
    private DataSourceRoutePropertiesDto dataSourceRouteDto;
    private AntPathMatcher matcher = new AntPathMatcher();
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObjectHandler = SystemMetaObject.forObject(DataSourceNameInterceptor.realTarget(statementHandler));
        MappedStatement mappedStatement = (MappedStatement)metaObjectHandler.getValue("delegate.mappedStatement");
        String sqlId = mappedStatement.getId();
        String dataSourceName = this.isMulti(sqlId);
        if (null != dataSourceName) {
            DataSourceRouteHandler.DATA_SOURCE_NAME.set(dataSourceName);
        } else if (this.isSharding(sqlId)) {
            DataSourceRouteHandler.DATA_SOURCE_NAME.set(null);
        } else {
            DataSourceRouteHandler.DATA_SOURCE_NAME.set(this.dataSourceRouteDto.getDefaultDataSourceName());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("set dataSourceName [{} -> {}]", (Object)sqlId, (Object)dataSourceName);
        }
        Object re = invocation.proceed();
        DataSourceRouteHandler.remove();
        return re;
    }

    private boolean isSharding(String sqlId) {
        Set<String> outs = this.dataSourceRouteDto.getOut();
        for (String out : outs) {
            if (!this.matcher.match(out, sqlId)) continue;
            return true;
        }
        return false;
    }

    private String isMulti(String sqlId) {
        Set<String> namespaces = this.dataSourceRouteDto.getNamespaces().keySet();
        for (String namespace : namespaces) {
            if (!this.matcher.match(namespace, sqlId)) continue;
            return this.dataSourceRouteDto.getNamespaces().get(namespace);
        }
        return null;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return DataSourceNameInterceptor.realTarget(metaObject.getValue("h.target"));
        }
        return (T)target;
    }

    public DataSourceRoutePropertiesDto getDataSourceRouteDto() {
        return this.dataSourceRouteDto;
    }

    public void setDataSourceRouteDto(DataSourceRoutePropertiesDto dataSourceRouteDto) {
        this.dataSourceRouteDto = dataSourceRouteDto;
    }
}

