/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.util;

import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class SecurityUtils {
    private static final Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String OAUTH2_BEARER_TYPE = "Bearer";
    public static final String OAUTH2_AUTHORIZATION = "Authorization";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String ANONYMOUS = "ROLE_ANONYMOUS";

    private SecurityUtils() {
    }

    public static String getCurrentUserToken() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.nonNull(requestAttributes)) {
            HttpServletRequest request = requestAttributes.getRequest();
            String header = SecurityUtils.extractOauth2Token(request);
            if (log.isDebugEnabled()) {
                log.debug("Get token from request header as: [{}]", (Object)header);
            }
            return header;
        }
        return null;
    }

    public static String extractOauth2Token(HttpServletRequest request) {
        Enumeration headers = request.getHeaders(OAUTH2_AUTHORIZATION);
        while (headers.hasMoreElements()) {
            String value = (String)headers.nextElement();
            if (!value.toLowerCase().startsWith(OAUTH2_BEARER_TYPE.toLowerCase())) continue;
            String authHeaderValue = value.substring(OAUTH2_BEARER_TYPE.length()).trim();
            int commaIndex = authHeaderValue.indexOf(44);
            if (commaIndex > 0) {
                authHeaderValue = authHeaderValue.substring(0, commaIndex);
            }
            return authHeaderValue;
        }
        if (request.getParameter(ACCESS_TOKEN) != null) {
            return request.getParameter(ACCESS_TOKEN);
        }
        return null;
    }

    public static String getCurrentUserLogin() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (Objects.nonNull(securityContext)) {
            Authentication authentication = securityContext.getAuthentication();
            String userName = null;
            if (authentication != null) {
                if (authentication.getPrincipal() instanceof UserDetails) {
                    UserDetails springSecurityUser = (UserDetails)authentication.getPrincipal();
                    userName = springSecurityUser.getUsername();
                } else if (authentication.getPrincipal() instanceof String) {
                    userName = (String)authentication.getPrincipal();
                }
            }
            return userName;
        }
        return null;
    }

    public static boolean isAuthenticated() {
        Authentication authentication;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (Objects.nonNull(securityContext) && (authentication = securityContext.getAuthentication()) != null) {
            return authentication.getAuthorities().stream().noneMatch(grantedAuthority -> ANONYMOUS.equals(grantedAuthority.getAuthority()));
        }
        return false;
    }

    public static boolean isCurrentUserInRole(String authority) {
        Authentication authentication;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (Objects.nonNull(securityContext) && (authentication = securityContext.getAuthentication()) != null) {
            return authentication.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals(authority));
        }
        return false;
    }
}

