/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.mask.web;

import cn.com.yusys.yusp.commons.session.mask.config.DataMaskResponseProperties;
import cn.com.yusys.yusp.commons.session.mask.web.DataMaskProcess;
import cn.com.yusys.yusp.commons.session.util.SessionUtils;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DataMaskProcessDefault
implements DataMaskProcess {
    private static final Logger LOG = LoggerFactory.getLogger(DataMaskProcessDefault.class);

    @Override
    public boolean isOpen() {
        HttpServletRequest request;
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (null != requestAttributes && null != (request = ((ServletRequestAttributes)requestAttributes).getRequest())) {
            if (this.checkFeign(request)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("feignclient\u8c03\u7528\uff0c\u4e0d\u505a\u8131\u654f");
                }
                return false;
            }
            if (this.checkUrls(request)) {
                return !this.checkIgnoreRoles(request);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("url\u672a\u914d\u7f6e\u8131\u654f\uff0c\u4e0d\u505a\u8131\u654f");
            }
            return false;
        }
        return false;
    }

    private boolean checkFeign(HttpServletRequest request) {
        String appName = request.getHeader("appName");
        return StringUtils.nonBlank((CharSequence)appName);
    }

    private boolean checkUrls(HttpServletRequest request) {
        DataMaskResponseProperties p = (DataMaskResponseProperties)SpringContextUtils.getBean(DataMaskResponseProperties.class);
        List<String> urls = p.getUrls();
        String url = request.getRequestURI();
        return null != urls && urls.contains(url);
    }

    private boolean checkIgnoreRoles(HttpServletRequest request) {
        DataMaskResponseProperties p = (DataMaskResponseProperties)SpringContextUtils.getBean(DataMaskResponseProperties.class);
        List<String> roles = p.getIgnoreRoles();
        String role = SessionUtils.getRoleId();
        return null != roles && roles.contains(role);
    }
}

