/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.context;

import cn.com.yusys.yusp.commons.session.SessionContext;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class UserContext {
    private static final String USER_KEY = "UserKey";
    private static final UserContext EMPTY_USER_CONTEXT = new UserContext();
    private Map<String, String> userContexts;

    public UserContext() {
        this.userContexts = new ConcurrentHashMap<String, String>();
    }

    public UserContext(Map<String, String> userContexts) {
        this.userContexts = userContexts;
    }

    public static void addUserContexts(Map<String, String> userContexts) {
        UserContext userContext = new UserContext(userContexts);
        SessionContext.put(USER_KEY, userContext);
    }

    public Map<String, String> getUserContexts() {
        return this.userContexts;
    }

    public String key(String key) {
        return this.userContexts.getOrDefault(key, null);
    }

    public void keys(String key, String value) {
        this.userContexts.put(key, value);
    }

    public static UserContext getUserContext() {
        return Optional.ofNullable((UserContext)SessionContext.get(USER_KEY)).orElse(EMPTY_USER_CONTEXT);
    }
}

