/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.util;

import cn.com.yusys.yusp.commons.session.SessionService;
import cn.com.yusys.yusp.commons.session.context.UserContext;
import cn.com.yusys.yusp.commons.session.user.Control;
import cn.com.yusys.yusp.commons.session.user.DataControl;
import cn.com.yusys.yusp.commons.session.user.MenuControl;
import cn.com.yusys.yusp.commons.session.user.User;
import cn.com.yusys.yusp.commons.session.user.UserData;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class SessionUtils {
    private static SessionService sessionService;

    private static void check() {
        if (sessionService == null) {
            SessionUtils.init();
        }
    }

    private static synchronized void init() {
        if (sessionService == null) {
            sessionService = (SessionService)SpringContextUtils.getBeanProvider(SessionService.class).getIfAvailable(SessionService.DefaultSessionService::new);
        }
    }

    public static String userKey(String key) {
        return Optional.ofNullable(UserContext.getUserContext()).map(context -> context.key(key)).orElse(null);
    }

    public static String getUserId() {
        return SessionUtils.userKey("user_id");
    }

    public static String getLoginCode() {
        return SessionUtils.userKey("login_code");
    }

    public static String getUserOrganizationId() {
        return SessionUtils.userKey("org_id");
    }

    public static String getClientId() {
        return SessionUtils.userKey("client_id");
    }

    public static String getRoleId() {
        return SessionUtils.userKey("role_id");
    }

    public static Map<String, String> getUserContexts() {
        return UserContext.getUserContext().getUserContexts();
    }

    public static User getUserInformation() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getUserInfo(user.key("client_id"), user.key("user_id"));
        }
        return null;
    }

    public static <T extends Control> List<T> getAllControls() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getAllControls();
        }
        return null;
    }

    public static MenuControl getMenuControl() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getMenuControl(user.key("client_id"), user.key("user_id"));
        }
        return null;
    }

    public static <T extends DataControl> List<T> getDataControl() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getDataControl(user.key("client_id"), user.key("user_id"));
        }
        return null;
    }

    public static UserData getUserDataInfo() {
        SessionUtils.check();
        UserContext user = UserContext.getUserContext();
        if (sessionService != null && user != null) {
            return sessionService.getUserDataInfo(user.key("client_id"), user.key("user_id"));
        }
        return null;
    }
}

