/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session;

import brave.Tracing;
import brave.baggage.BaggageField;
import brave.propagation.CurrentTraceContext;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionContext {
    private static final Logger logger = LoggerFactory.getLogger(SessionContext.class);
    private static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    private static final String CLASS_SUFFIX = "_class";
    public static final String SESSION_FIELD_NAME = "session-context";
    private static final ThreadLocal<Map<String, Object>> CONTEXT_THREAD_LOCAL = new TransmittableThreadLocal<Map<String, Object>>(){

        protected Map<String, Object> initialValue() {
            return new ConcurrentHashMap<String, Object>(8);
        }
    };

    public static void put(String key, Object value) {
        if (StringUtils.nonEmpty((CharSequence)key) && Objects.nonNull(value)) {
            CONTEXT_THREAD_LOCAL.get().put(key, value);
            SessionContext.traceContextSet();
        }
    }

    public static <T> T get(String key) {
        if (CONTEXT_THREAD_LOCAL.get().isEmpty()) {
            SessionContext.initSessionContext();
        }
        return (T)CONTEXT_THREAD_LOCAL.get().get(key);
    }

    private static void traceContextSet() {
        HashMap<String, Object> context = new HashMap<String, Object>(CONTEXT_THREAD_LOCAL.get());
        HashMap<String, Object> traceMap = new HashMap<String, Object>(context.size());
        for (String key : context.keySet()) {
            Object value = context.get(key);
            if (value == null) continue;
            String strValue = SessionContext.serialize(value);
            traceMap.put(key + CLASS_SUFFIX, value.getClass());
            traceMap.put(key, strValue);
        }
        BaggageField field = BaggageField.create((String)SESSION_FIELD_NAME);
        String value = SessionContext.serialize(traceMap);
        Optional.ofNullable(Tracing.current()).map(Tracing::currentTraceContext).map(CurrentTraceContext::get).ifPresent(traceContext -> field.updateValue(traceContext, value));
    }

    public static void initSessionContext() {
        if (CONTEXT_THREAD_LOCAL.get().isEmpty()) {
            BaggageField field = BaggageField.create((String)SESSION_FIELD_NAME);
            String value = Optional.ofNullable(Tracing.current()).map(Tracing::currentTraceContext).map(CurrentTraceContext::get).map(arg_0 -> ((BaggageField)field).getValue(arg_0)).orElse(null);
            Map context = (Map)SessionContext.deserialize(value, HashMap.class.getName());
            if (context != null) {
                HashMap traceContext = new HashMap(context.size());
                context.entrySet().stream().filter(entry -> !((String)entry.getKey()).endsWith(CLASS_SUFFIX)).forEach(entry -> {
                    Map jsonMap = (Map)SessionContext.deserialize((String)entry.getValue(), HashMap.class.getName());
                    if (jsonMap != null) {
                        Class userContext = ReflectionUtils.forName((String)((String)context.get((String)entry.getKey() + CLASS_SUFFIX)));
                        Class[] paramsTypes = new Class[]{Map.class};
                        Object object = null;
                        try {
                            object = userContext.getDeclaredConstructor(paramsTypes).newInstance(jsonMap);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                            logger.error("constructor instance exception!", (Throwable)e);
                        }
                        traceContext.put((String)entry.getKey(), object);
                    }
                });
                Optional.of(traceContext).ifPresent(CONTEXT_THREAD_LOCAL.get()::putAll);
            }
        }
    }

    private static String serialize(Object object) {
        try {
            String value = ObjectMapperUtils.toJson((Object)object);
            return Base64.encodeBase64String((byte[])value.getBytes(DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException | RuntimeException e) {
            logger.error("serialize user info occur exception!", (Throwable)e);
            return null;
        }
    }

    private static <T> T deserialize(String value, String className) {
        if (StringUtils.nonEmpty((CharSequence)value) && StringUtils.nonEmpty((CharSequence)className)) {
            try {
                String json = new String(Base64.decodeBase64((String)value), DEFAULT_CHARSET);
                return (T)ObjectMapperUtils.toObject((String)json, (Class)ReflectionUtils.forName((String)className));
            }
            catch (UnsupportedEncodingException | RuntimeException e) {
                logger.error("deserialize user info occur exception!", (Throwable)e);
            }
        }
        return null;
    }

    public static void clean() {
        CONTEXT_THREAD_LOCAL.remove();
    }
}

