/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.context;

import cn.com.yusys.yusp.commons.session.SessionContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class UserContext {
    private static final String USER_KEY = "UserKey";
    private static final UserContext EMPTY_USER_CONTEXT = new UserContext();
    private Map<String, String> userContexts;

    public UserContext() {
        this.userContexts = new ConcurrentHashMap<String, String>();
    }

    public UserContext(Map<String, String> userContexts) {
        this.userContexts = userContexts;
    }

    public static void addUserContexts(Map<String, String> userContexts) {
        UserContext userContext = new UserContext(userContexts);
        SessionContext.put(USER_KEY, userContext);
    }

    public Map<String, String> getUserContexts() {
        return this.userContexts;
    }

    public String key(String key) {
        return this.userContexts.getOrDefault(key, null);
    }

    public void keys(String key, String value) {
        this.userContexts.put(key, value);
    }

    @Deprecated
    public UserContext(String clientId, String userId, String loginCode, String organizationId) {
        this.userContexts = new ConcurrentHashMap<String, String>();
        this.setClientId(clientId);
        this.setLoginCode(loginCode);
        this.setUserId(userId);
        this.setOrganizationId(organizationId);
    }

    @Deprecated
    public static UserContext of(String clientId, String userId, String loginCode, String organizationId) {
        return new UserContext(clientId, userId, loginCode, organizationId);
    }

    @Deprecated
    public static void addUserContext(String clientId, String userId, String loginCode, String organizationId) {
        UserContext.addUserContext(UserContext.of(clientId, userId, loginCode, organizationId));
    }

    @Deprecated
    public static void addUserContext(UserContext userContext) {
        SessionContext.put(USER_KEY, userContext);
    }

    public static UserContext getUserContext() {
        return Optional.ofNullable((UserContext)SessionContext.get(USER_KEY)).orElse(EMPTY_USER_CONTEXT);
    }

    @Deprecated
    @JsonIgnore
    public String getClientId() {
        return this.key("client_id");
    }

    @Deprecated
    @JsonIgnore
    public String getUserId() {
        return this.key("user_id");
    }

    @Deprecated
    public void setUserId(String userId) {
        this.keys("user_id", userId);
    }

    @Deprecated
    @JsonIgnore
    public String getLoginCode() {
        return this.key("login_code");
    }

    @Deprecated
    public void setLoginCode(String loginCode) {
        this.keys("login_code", loginCode);
    }

    @Deprecated
    @JsonIgnore
    public String getOrganizationId() {
        return this.key("org_id");
    }

    @Deprecated
    @JsonIgnore
    public String getParam(String key) {
        return this.key(key);
    }

    @Deprecated
    public UserContext param(String key, String value) {
        this.keys(key, value);
        return this;
    }

    @Deprecated
    public void setClientId(String clientId) {
        this.keys("client_id", clientId);
    }

    @Deprecated
    public void setOrganizationId(String organizationId) {
        this.keys("org_id", organizationId);
    }

    @Deprecated
    @JsonIgnore
    public Map<String, String> getExtParams() {
        return this.getUserContexts();
    }

    @Deprecated
    public void setExtParams(Map<String, String> extParams) {
        this.userContexts.putAll(extParams);
    }
}

