/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.session.context;

import cn.com.yusys.yusp.commons.session.SessionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class UserContext {
    private static final String USER_KEY = "UserKey";
    private static final UserContext EMPTY_USER_CONTEXT = new UserContext();
    private String clientId;
    private String userId;
    private String loginCode;
    private String organizationId;
    private Map<String, String> extParams;

    public UserContext() {
    }

    public UserContext(String clientId, String userId, String loginCode, String organizationId) {
        this.clientId = clientId;
        this.loginCode = loginCode;
        this.userId = userId;
        this.organizationId = organizationId;
    }

    public static UserContext of(String clientId, String userId, String loginCode, String organizationId) {
        return new UserContext(clientId, userId, loginCode, organizationId);
    }

    public static void addUserContext(String clientId, String userId, String loginCode, String organizationId) {
        UserContext.addUserContext(UserContext.of(clientId, userId, loginCode, organizationId));
    }

    public static void addUserContext(UserContext userContext) {
        SessionContext.put(USER_KEY, userContext);
    }

    public static UserContext getUserContext() {
        return Optional.ofNullable((UserContext)SessionContext.get(USER_KEY)).orElse(EMPTY_USER_CONTEXT);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLoginCode() {
        return this.loginCode;
    }

    public void setLoginCode(String loginCode) {
        this.loginCode = loginCode;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getParam(String key) {
        return Objects.nonNull(this.extParams) ? this.extParams.get(key) : null;
    }

    public UserContext param(String key, String value) {
        if (this.extParams == null) {
            this.extParams = new HashMap<String, String>(8);
        }
        this.extParams.put(key, value);
        return this;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Map<String, String> getExtParams() {
        return this.extParams;
    }

    public void setExtParams(Map<String, String> extParams) {
        this.extParams = extParams;
    }
}

