DROP TABLE IF EXISTS `SEQUENCE_LEAF`;

CREATE TABLE `SEQUENCE_LEAF` (
  `seq_id` varchar(30)  NOT NULL DEFAULT '' comment '序列号id',
  `max_id` bigint(20) NOT NULL DEFAULT 0 comment 'leaf方式判断每个号段是否用尽的标识',
  `step` int(11) NOT NULL default 1000 comment '初始化号段时的步长，新增时默认为1000',
  `is_max` tinyint default 0 comment '标识不设置最大值循环时，当前seqId下的序列号是已否达到最大值',
  `description` varchar(256)  DEFAULT NULL comment '当前序列号的描述',
  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP comment '最后更新时间',
  PRIMARY KEY (`seq_id`)
) ENGINE=InnoDB comment 'leaf序列号表';

# 示例：默认序列号初始值为 1，步长为1000，序列号标id为 test
insert into SEQUENCE_LEAF(seq_id, max_id, step, is_max, description) values('test', 0, 1000, 0, '序列号标识符为test');