/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.service.impl;

import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.mapper.IdGenMapper;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.model.IdGenEntity;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.service.IdGenService;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class IdGenServiceImpl
implements IdGenService,
ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private IdGenMapper idGenMapper;
    private ApplicationContext applicationContext;
    TransactionTemplate transactionTemplate;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.idGenMapper = (IdGenMapper)this.applicationContext.getBean(IdGenMapper.class);
        this.transactionTemplate = (TransactionTemplate)this.applicationContext.getBean(TransactionTemplate.class);
    }

    @Override
    public List<String> getAllKeys() {
        List<String> allKeys = this.idGenMapper.getAllKeys();
        return allKeys;
    }

    @Override
    public IdGenEntity setMaxIdAndGetIdGenCycle(String seqId, long limit) {
        IdGenEntity idGenEntity = (IdGenEntity)this.transactionTemplate.execute(status -> {
            IdGenEntity idGenEntityBefore = this.idGenMapper.getIdGen(seqId);
            int i = this.idGenMapper.updateMaxIdCycle(seqId, limit, idGenEntityBefore.getMaxId());
            if (i == 0) {
                throw new SequenceException("\u5f53\u524d\u53f7\u6bb5\u5df2\u88ab\u4f7f\u7528\uff0c\u9700\u91cd\u65b0\u83b7\u53d6\uff01");
            }
            IdGenEntity idGenEntityTmp = this.idGenMapper.getIdGen(seqId);
            if (idGenEntityTmp.getStep() >= limit) {
                status.setRollbackOnly();
                throw new RuntimeException("\u6570\u636e\u5e93\u4e2d\u6b65\u957f\u9700\u5c0f\u4e8e\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bbe\u5b9a\u7684\u6700\u5927\u503c\uff0c\u8bf7\u4fee\u6539\uff01");
            }
            return idGenEntityTmp;
        });
        return idGenEntity;
    }

    @Override
    public IdGenEntity setMaxIdAndGetIdGen(String seqId, long limit) {
        IdGenEntity idGenEntity = (IdGenEntity)this.transactionTemplate.execute(status -> {
            IdGenEntity idGenEntityBefore = this.idGenMapper.getIdGen(seqId);
            int i = this.idGenMapper.updateMaxId(seqId, limit, idGenEntityBefore.getMaxId());
            if (i == 0) {
                throw new SequenceException("\u5f53\u524d\u53f7\u6bb5\u5df2\u88ab\u4f7f\u7528\uff0c\u9700\u91cd\u65b0\u83b7\u53d6\uff01");
            }
            IdGenEntity idGenEntityTmp = this.idGenMapper.getIdGen(seqId);
            if (idGenEntityTmp.getStep() >= limit) {
                status.setRollbackOnly();
                throw new RuntimeException("\u6570\u636e\u5e93\u4e2d\u6b65\u957f\u9700\u5c0f\u4e8e\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bbe\u5b9a\u7684\u6700\u5927\u503c\uff0c\u8bf7\u4fee\u6539\uff01");
            }
            return idGenEntityTmp;
        });
        return idGenEntity;
    }

    @Override
    public int updateStatus(String seqId, int status) {
        return this.idGenMapper.updateStatus(seqId, status);
    }

    @Override
    public void createSequence(final String seqId) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                List<String> allKeys = IdGenServiceImpl.this.idGenMapper.getAllKeys();
                if (allKeys.contains(seqId)) {
                    throw new SequenceException("\u5e8f\u5217\u53f7\u5df2\u5b58\u5728\uff01");
                }
                IdGenServiceImpl.this.idGenMapper.createSequence(seqId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dropSequence(String seqId) {
        IdGenServiceImpl idGenServiceImpl = this;
        synchronized (idGenServiceImpl) {
            return this.idGenMapper.dropSequence(seqId);
        }
    }
}

