/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.leaf;

import cn.com.yusys.yusp.commons.sequence.AbstractSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.sequence.generator.leaf.leaf.IdGenImpl;
import cn.com.yusys.yusp.commons.util.Asserts;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafSequenceGenerator
extends AbstractSequenceGenerator {
    private static Logger logger = LoggerFactory.getLogger(LeafSequenceGenerator.class);
    IdGenImpl idGenImpl;
    private long currentSeqNo = -1L;

    public LeafSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter, IdGenImpl idGenImpl) {
        super(sequenceConfigs, sequenceIdConverter);
        this.idGenImpl = idGenImpl;
    }

    public LeafSequenceGenerator(List<SequenceConfig> sequenceConfigs, IdGenImpl idGenImpl) {
        super(sequenceConfigs);
        this.idGenImpl = idGenImpl;
    }

    public String supportedType() {
        return GeneratorType.LEAF.name();
    }

    @Override
    public int cleanup(String ... seqIds) {
        int count = 0;
        for (String seqId : seqIds) {
            count += this.deleteSequence(seqId);
        }
        return count;
    }

    @Override
    public long getCurrentSequenceNo(String seqId) throws SequenceException {
        this.checkSequenceConfig(seqId);
        String convertSeqId = this.getSequenceIdConverter().convert(seqId);
        if (this.currentSeqNo == -1L) {
            SequenceConfig config = this.getSequenceConfig(seqId);
            long limit = config.getMaxValue();
            this.currentSeqNo = this.idGenImpl.getId(convertSeqId, limit, config);
        }
        return this.currentSeqNo;
    }

    @Override
    public long getSequenceNo(String seqId) throws SequenceException {
        this.checkSequenceConfig(seqId);
        SequenceConfig config = this.getSequenceConfig(seqId);
        long limit = config.getMaxValue();
        String convertId = this.getSequenceIdConverter().convert(seqId);
        return this.idGenImpl.getId(convertId, limit, config);
    }

    @Override
    public String getSequence(String seqId, Map<String, String> paramMap) throws SequenceException {
        this.checkSequenceConfig(seqId);
        return this.parseSequenceByTemplate(seqId, String.valueOf(this.getSequenceNo(seqId)), paramMap);
    }

    private void checkSequenceConfig(String seqId) {
        SequenceConfig sequenceConfig = this.getSequenceConfig(seqId);
        Asserts.nonNull((Object)sequenceConfig, (Object[])new Object[]{"Sequence Id [%s] not found config information!", seqId});
    }

    @Override
    public boolean createSequence(String seqId) throws SequenceException {
        this.idGenImpl.createSequence(seqId);
        return true;
    }

    @Override
    public boolean dropSequence(String seqId, boolean removeConfig) throws SequenceException {
        int i = this.deleteSequence(seqId);
        if (removeConfig) {
            this.removeLockObject(seqId);
        }
        if (i != 0) {
            return super.dropSequence(seqId, removeConfig);
        }
        return true;
    }

    public int deleteSequence(String seqId) {
        return this.idGenImpl.dropSequence(seqId);
    }
}

