/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence;

import cn.com.yusys.yusp.commons.sequence.AbstractSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.Sequence;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.util.IdConverterUtils;
import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class TimedCleanExpiredSequenceId {
    private static final Logger logger = LoggerFactory.getLogger(TimedCleanExpiredSequenceId.class);
    private final List<AbstractSequenceGenerator> sequences;
    private final int cleanExpiredCount;
    private final int reserveCount;
    private final SequenceIdConverter converter;

    public TimedCleanExpiredSequenceId(List<Sequence> sequences, SequenceIdConverter converter, int cleanExpiredCount, int reserveCount) {
        this.sequences = CollectionUtils.nonEmpty(sequences) ? sequences.stream().filter(sequence -> AbstractSequenceGenerator.class.isAssignableFrom(sequence.getClass())).map(sequence -> (AbstractSequenceGenerator)sequence).collect(Collectors.toList()) : Collections.emptyList();
        this.cleanExpiredCount = Math.max(cleanExpiredCount, 0);
        this.reserveCount = Math.max(reserveCount, 0);
        this.converter = Objects.nonNull(converter) ? converter : new SequenceIdConverter.DefaultConverter();
    }

    @Scheduled(cron="${yusp.sequence.cleanup.cron:0 0 0 * * ?}")
    public void clean() {
        logger.info("Start cleanup expired sequence id!");
        if (CollectionUtils.isEmpty(this.sequences) || this.cleanExpiredCount == 0) {
            return;
        }
        List<SequenceConfig> sequenceConfigs = this.sequences.get(0).getSequenceConfigs();
        int cleanup = 0;
        if (CollectionUtils.nonEmpty(sequenceConfigs)) {
            Object[] seqIds = (String[])sequenceConfigs.stream().filter(config -> !CycleType.NONE.equals((Object)config.getCycleType()) && !CycleType.MAX.equals((Object)config.getCycleType())).map(this::deduceNeedToCleanUpSequenceId).filter(ArrayUtils::nonEmpty).flatMap(Stream::of).distinct().toArray(String[]::new);
            logger.info("Current need checkup sequence id is: {}", (Object)Arrays.toString(seqIds));
            AbstractSequenceGenerator mainSequence = (AbstractSequenceGenerator)SequenceUtils.getMainSequence();
            cleanup = mainSequence.cleanup((String[])seqIds);
        }
        logger.info("End cleanup expired sequence id! Current cleanup count is: {}", (Object)cleanup);
    }

    private String[] deduceNeedToCleanUpSequenceId(SequenceConfig config) {
        HashSet<String> convertSeqIds = new HashSet<String>();
        for (int i = 0; i < this.cleanExpiredCount; ++i) {
            String suffix = IdConverterUtils.getFrontIdSuffix(config.getCycleType(), this.reserveCount + i);
            if (!StringUtils.nonEmpty((CharSequence)suffix)) continue;
            convertSeqIds.add(StringUtils.builder0((Object[])new Object[]{this.converter.convert(config.getSeqId()), suffix}));
        }
        return convertSeqIds.toArray(new String[0]);
    }
}

