/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence;

import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.util.Asserts;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public interface Sequence {
    public long getCurrentSequenceNo(String var1) throws SequenceException;

    default public String getSequence(String seqId) throws SequenceException {
        return this.getSequence(seqId, null);
    }

    public long getSequenceNo(String var1) throws SequenceException;

    public String getSequence(String var1, Map<String, String> var2) throws SequenceException;

    default public List<String> getBatchSequence(String seqId, int number) throws SequenceException {
        return this.getBatchSequence(seqId, number, null);
    }

    default public List<String> getBatchSequence(String seqId, int number, Map<String, String> paramMap) throws SequenceException {
        Asserts.maxNumber((Number)number, (Number)0, (Object[])new Object[]{"get sequence number must  Greater than or equal to zero!"});
        LinkedList<String> sequences = new LinkedList<String>();
        for (int i = 0; i < number; ++i) {
            sequences.add(this.getSequence(seqId, paramMap));
        }
        return sequences;
    }

    default public void resetSequence(String seqId) throws SequenceException {
        this.dropSequence(seqId, false);
        this.createSequence(seqId);
    }

    public boolean dropSequence(String var1, boolean var2) throws SequenceException;

    public boolean createSequence(String var1) throws SequenceException;

    public boolean addSequenceConfig(SequenceConfig var1) throws SequenceException;

    public boolean updateSequenceConfig(SequenceConfig var1) throws SequenceException;
}

