/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.util;

import cn.com.yusys.yusp.commons.sequence.AbstractSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.Sequence;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class SequenceUtils {
    private static String MAIN_GENERATE_TYPE = GeneratorType.SNOWFLAKE.name();
    private static final AtomicBoolean INITIALING = new AtomicBoolean(false);
    private static final Map<String, Sequence> SEQUENCE_MAP = new ConcurrentHashMap<String, Sequence>();

    private SequenceUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void initialing(String mainGenerateType) {
        Asserts.nonEmpty((CharSequence)mainGenerateType, (Object[])new Object[]{"Main generator name must not empty!"});
        if (INITIALING.compareAndSet(false, true)) {
            MAIN_GENERATE_TYPE = mainGenerateType;
        }
    }

    private static Sequence getSequenceByGenerateType(String generateType) {
        Sequence sequence;
        if (!SEQUENCE_MAP.containsKey(generateType) && Objects.nonNull(sequence = (Sequence)SpringContextUtils.getBeansOfType(Sequence.class).values().parallelStream().filter(seq -> seq instanceof AbstractSequenceGenerator).map(seq -> (AbstractSequenceGenerator)seq).filter(seq -> ((String)seq.supportedType()).equalsIgnoreCase(generateType)).findFirst().orElse(null))) {
            SEQUENCE_MAP.putIfAbsent(generateType, sequence);
        }
        sequence = SEQUENCE_MAP.get(generateType);
        Asserts.nonNull((Object)sequence, (Object[])new Object[]{"Sequence generate type [%s] not config!", generateType});
        return sequence;
    }

    public static Sequence getMainSequence() {
        return SequenceUtils.getSequenceByGenerateType(MAIN_GENERATE_TYPE);
    }

    public static String getSequence(String seqId) {
        return SequenceUtils.getSequence(MAIN_GENERATE_TYPE, seqId);
    }

    public static String getSequence(String generateType, String seqId) {
        return SequenceUtils.getSequenceByGenerateType(generateType).getSequence(seqId);
    }

    public static String getSequence(String seqId, Map<String, String> map) {
        return SequenceUtils.getSequence(MAIN_GENERATE_TYPE, seqId, map);
    }

    public static String getSequence(String generateType, String seqId, Map<String, String> map) {
        return SequenceUtils.getSequenceByGenerateType(generateType).getSequence(seqId, map);
    }

    public static long getSequenceNo(String seqId) {
        return SequenceUtils.getSequenceNo(MAIN_GENERATE_TYPE, seqId);
    }

    public static long getSequenceNo(String generateType, String seqId) {
        return SequenceUtils.getSequenceByGenerateType(generateType).getSequenceNo(seqId);
    }

    public static void resetSequence(String seqId) {
        SequenceUtils.resetSequence(MAIN_GENERATE_TYPE, seqId);
    }

    public static void resetSequence(String generateType, String seqId) {
        SequenceUtils.getSequenceByGenerateType(generateType).resetSequence(seqId);
    }

    public static long currentSequenceNo(String seqId) {
        return SequenceUtils.currentSequenceNo(MAIN_GENERATE_TYPE, seqId);
    }

    public static long currentSequenceNo(String generateType, String seqId) {
        return SequenceUtils.getSequenceByGenerateType(generateType).getCurrentSequenceNo(seqId);
    }

    public static boolean updateSequenceConfig(SequenceConfig sequenceConfig) {
        return SequenceUtils.getSequenceByGenerateType(MAIN_GENERATE_TYPE).updateSequenceConfig(sequenceConfig);
    }
}

