/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.db;

import cn.com.yusys.yusp.commons.enumeration.DbType;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.sequence.enumeration.CycleType;
import cn.com.yusys.yusp.commons.sequence.enumeration.GeneratorType;
import cn.com.yusys.yusp.commons.sequence.generator.db.AbstractDatabaseSequenceGenerator;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;

public class SqlServerSequenceGenerator
extends AbstractDatabaseSequenceGenerator {
    public SqlServerSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter, JdbcTemplate jdbcTemplate) {
        super(sequenceConfigs, sequenceIdConverter, jdbcTemplate);
    }

    @Override
    String querySql(String seqId) {
        return String.format("select count(*) from sys.sequences where name ='%s'", seqId);
    }

    @Override
    String dropSql(String seqId) {
        return String.format("drop sequence %s", seqId);
    }

    @Override
    String createSql(String seqId, SequenceConfig config) {
        return StringUtils.builder0((Object[])new Object[]{"create sequence ", seqId, " minvalue ", config.getStartValue(), " maxvalue ", config.getMaxValue(), " start with ", config.getStartValue(), " increment by ", config.getIncrementValue(), " cache ", config.getCacheValue(), CycleType.MAX.equals((Object)config.getCycleType()) ? " cycle " : ""});
    }

    @Override
    protected String nextSql(String seqId) {
        return String.format("select next value for %s ", seqId);
    }

    @Override
    String currentSql(String seqId) {
        return String.format("SELECT cast([current_value] as varchar(20)) FROM sys.sequences WHERE name='%s'", seqId);
    }

    @Override
    String batchNextSql(String sequenceName, int number) {
        throw new UnsupportedOperationException("current database is not supported batch get sequence sql!");
    }

    public boolean isSupported(DbType type) {
        return DbType.SQL_SERVER.equals((Object)type);
    }

    public String supportedType() {
        return GeneratorType.SQLSERVER.name();
    }
}

