/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.sequence.generator.db;

import cn.com.yusys.yusp.commons.core.Supported;
import cn.com.yusys.yusp.commons.enumeration.DbType;
import cn.com.yusys.yusp.commons.sequence.AbstractSequenceGenerator;
import cn.com.yusys.yusp.commons.sequence.SequenceConfig;
import cn.com.yusys.yusp.commons.sequence.SequenceException;
import cn.com.yusys.yusp.commons.sequence.SequenceIdConverter;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.DataSourceUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractDatabaseSequenceGenerator
extends AbstractSequenceGenerator
implements Supported<DbType> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDatabaseSequenceGenerator.class);
    private static final String NO_SEQUENCE = "\u5e8f\u5217\u4e0d\u5b58\u5728";
    private JdbcTemplate jdbcTemplate;

    public AbstractDatabaseSequenceGenerator(List<SequenceConfig> sequenceConfigs, JdbcTemplate jdbcTemplate) {
        super(sequenceConfigs);
        this.jdbcTemplate = jdbcTemplate;
    }

    public AbstractDatabaseSequenceGenerator(List<SequenceConfig> sequenceConfigs, SequenceIdConverter sequenceIdConverter, JdbcTemplate jdbcTemplate) {
        super(sequenceConfigs, sequenceIdConverter);
        this.jdbcTemplate = jdbcTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> executeQuery(String sql, String nextSql, String seqId, SequenceConfig sequenceConfig) throws SequenceException {
        List<String> list;
        Asserts.nonNull((Object)seqId, (Object[])new Object[]{"Sequence ID cannot be empty!"});
        Statement state = null;
        Connection conn = null;
        DataSource dataSource = null;
        dataSource = this.jdbcTemplate.getDataSource();
        conn = dataSource.getConnection();
        state = conn.createStatement();
        try {
            list = this.readResult(state.executeQuery(sql));
        }
        catch (SequenceException | SQLException e) {
            try {
                List<String> list2 = this.readResult(state.executeQuery(nextSql));
                this.releaseConnection(null, state, conn, dataSource);
                return list2;
            }
            catch (Exception e1) {
                try {
                    List<String> list3 = this.getLockObject(seqId);
                    synchronized (list3) {
                        this.createSequence(seqId, sequenceConfig, conn);
                    }
                    list3 = this.readResult(state.executeQuery(nextSql));
                    this.releaseConnection(null, state, conn, dataSource);
                    return list3;
                }
                catch (Exception e2) {
                    try {
                        throw new SequenceException(e2);
                    }
                    catch (Throwable throwable) {
                        this.releaseConnection(null, state, conn, dataSource);
                        throw throwable;
                    }
                }
            }
        }
        this.releaseConnection(null, state, conn, dataSource);
        return list;
    }

    protected List<String> readResult(ResultSet resultSet) throws SequenceException {
        block6: {
            if (!Objects.nonNull(resultSet)) break block6;
            LinkedList<String> values = new LinkedList<String>();
            try {
                while (resultSet.next()) {
                    String value = StringUtils.replaceObjNull((Object)resultSet.getObject(1));
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        throw new SequenceException("not found this sequence");
                    }
                    values.add(value);
                }
            }
            catch (SQLException e) {
                try {
                    throw new SequenceException(e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.close((AutoCloseable[])new AutoCloseable[]{resultSet});
                    throw throwable;
                }
            }
            IOUtils.close((AutoCloseable[])new AutoCloseable[]{resultSet});
            return values;
        }
        throw new SequenceException("Error occurred when getting next value of sequence\uff01");
    }

    protected void releaseConnection(ResultSet rs, Statement state, Connection connection, DataSource dataSource) {
        IOUtils.close((AutoCloseable[])new AutoCloseable[]{rs, state});
        if (connection != null) {
            org.springframework.jdbc.datasource.DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    protected void createSequence(String seqId, SequenceConfig sequenceConfig, Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(this.querySql(sequenceConfig.getSeqId()));){
            if (rs.next() && "0".equals(rs.getString(1))) {
                stmt.execute(this.createSql(seqId, sequenceConfig));
            }
        }
    }

    abstract String querySql(String var1);

    abstract String dropSql(String var1);

    abstract String createSql(String var1, SequenceConfig var2);

    abstract String batchNextSql(String var1, int var2);

    protected String nextSql(String seqId) {
        return this.batchNextSql(seqId, 1);
    }

    abstract String currentSql(String var1);

    @Override
    public long getCurrentSequenceNo(String seqId) throws SequenceException {
        String convertSeqId = this.getSequenceIdConverter().convert(seqId);
        List<String> sequences = this.executeQuery(this.currentSql(convertSeqId), this.nextSql(convertSeqId), convertSeqId, this.getSequenceConfig(seqId));
        return CollectionUtils.nonEmpty(sequences) ? Long.parseLong(sequences.get(0)) : -1L;
    }

    @Override
    public long getSequenceNo(String seqId) throws SequenceException {
        String convertSeqId = this.getSequenceIdConverter().convert(seqId);
        List<String> sequences = this.executeQuery(this.nextSql(convertSeqId), this.nextSql(convertSeqId), convertSeqId, this.getSequenceConfig(seqId));
        return CollectionUtils.nonEmpty(sequences) ? Long.parseLong(sequences.get(0)) : -1L;
    }

    @Override
    public String getSequence(String seqId, Map<String, String> paramMap) throws SequenceException {
        long nextSequence = this.getSequenceNo(seqId);
        return nextSequence > -1L ? this.parseSequenceByTemplate(seqId, String.valueOf(nextSequence), paramMap) : null;
    }

    private void deleteSequence(String seqId) throws SequenceException {
        Asserts.nonEmpty((CharSequence)seqId, (Object[])new Object[]{"Sequence IDs cannot be empty!"});
        String convertSeqId = this.getSequenceIdConverter().convert(seqId);
        Statement state = null;
        Connection conn = null;
        DataSource dataSource = null;
        try {
            block6: {
                dataSource = this.jdbcTemplate.getDataSource();
                conn = dataSource.getConnection();
                state = conn.createStatement();
                try {
                    state.execute(this.dropSql(convertSeqId));
                }
                catch (SQLException e) {
                    if (e.getMessage().contains(NO_SEQUENCE)) break block6;
                    throw new SequenceException(e);
                }
            }
            this.releaseConnection(null, state, conn, dataSource);
        }
        catch (Exception e) {
            try {
                throw new SequenceException(e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(null, state, conn, dataSource);
                throw throwable;
            }
        }
    }

    @Override
    public boolean dropSequence(String seqId, boolean removeConfig) throws SequenceException {
        this.deleteSequence(seqId);
        if (removeConfig) {
            this.removeLockObject(seqId);
        }
        return super.dropSequence(seqId, removeConfig);
    }

    @Override
    public boolean createSequence(String seqId) throws SequenceException {
        Asserts.nonEmpty((CharSequence)seqId, (Object[])new Object[]{"Sequence ID cannot be empty!"});
        String convertSeqId = this.getSequenceIdConverter().convert(seqId);
        Connection connection = null;
        ResultSet rs = null;
        Statement state = null;
        DataSource dataSource = null;
        try {
            dataSource = this.jdbcTemplate.getDataSource();
            connection = dataSource.getConnection();
            state = connection.createStatement();
            rs = state.executeQuery(this.querySql(convertSeqId));
            if (rs.next() && rs.getInt(1) > 0) {
                throw new SequenceException("\u8be5\u5e8f\u5217\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0!");
            }
            this.createSequence(convertSeqId, this.getSequenceConfig(seqId), connection);
            this.releaseConnection(rs, state, connection, dataSource);
        }
        catch (Exception e) {
            try {
                throw new SequenceException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.releaseConnection(rs, state, connection, dataSource);
                throw throwable;
            }
        }
        return true;
    }

    protected JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cleanup(String ... seqIds) {
        String dbType = DataSourceUtils.dialect((DataSource)this.jdbcTemplate.getDataSource());
        if (StringUtils.isEmpty((CharSequence)dbType) || !this.isSupported(DbType.getDbType((String)dbType))) {
            logger.warn("Current connect database type:{} not supported!", (Object)dbType);
            return 0;
        }
        int count = 0;
        Connection connection = null;
        Statement state = null;
        DataSource dataSource = null;
        try {
            dataSource = this.jdbcTemplate.getDataSource();
            connection = dataSource.getConnection();
            state = connection.createStatement();
            for (String seqId : seqIds) {
                count += this.cleanup(state, seqId);
            }
            this.releaseConnection(null, state, connection, dataSource);
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                this.releaseConnection(null, state, connection, dataSource);
            }
            catch (Throwable throwable) {
                this.releaseConnection(null, state, connection, dataSource);
                throw throwable;
            }
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int cleanup(Statement statement, String seqId) {
        Asserts.nonEmpty((CharSequence)seqId, (Object[])new Object[]{"Sequence ID cannot be empty!"});
        try (ResultSet rs = statement.executeQuery(this.dropSql(seqId));){
            int n = rs.next() ? rs.getInt(1) : 0;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

