/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.security.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.header.writers.StaticHeadersWriter;

public class WebSecurityFilter
implements Filter {
    private Logger log = LoggerFactory.getLogger(WebSecurityFilter.class);
    private StaticHeadersWriter headerWriters;
    private boolean overrideSecurityHeader = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        String override = filterConfig.getInitParameter("overrideSecurityHeader");
        this.overrideSecurityHeader = Boolean.valueOf(override);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.headerWriters == null) {
            this.log.warn("Security Headers not init!");
        }
        if (!(request instanceof HttpServletRequest)) {
            this.log.warn("Request is no HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            this.log.warn("Response is no HttpServletResponse");
        }
        if (this.headerWriters != null && request instanceof HttpServletRequest && response instanceof HttpServletResponse && !this.overrideSecurityHeader) {
            this.log.debug("Write Security Headers");
            this.headerWriters.writeHeaders((HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
        if (this.overrideSecurityHeader && this.headerWriters != null) {
            this.log.debug("Write Security Headers after Security Filters");
            this.headerWriters.writeHeaders((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    public void setHeaderWriters(StaticHeadersWriter headerWriters) {
        this.headerWriters = headerWriters;
    }

    public void destroy() {
    }
}

