/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.security.web.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLInjectionServletFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(SQLInjectionServletFilter.class);
    private static String regex = "";
    private Pattern sqlPattern;

    public void init(FilterConfig filterConfig) throws ServletException {
        regex = filterConfig.getInitParameter("regex");
        this.sqlPattern = Pattern.compile(regex, 2);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Enumeration params = servletRequest.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String[] value = servletRequest.getParameterValues(name);
            for (int i = 0; i < value.length; ++i) {
                if (this.isValid(value[i])) continue;
                throw new IOException("The parameter in your request contains illegal characters:" + value[i]);
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private boolean isValid(String str) {
        if (this.sqlPattern.matcher(str).find()) {
            logger.error("sql injection\uff1astr={}", (Object)str);
            return false;
        }
        return true;
    }
}

