/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.util;

import cn.com.yusys.yusp.commons.ribbon.RouteConfig;
import cn.com.yusys.yusp.commons.ribbon.config.ServiceMappingProperties;
import cn.com.yusys.yusp.commons.util.ObjectUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public final class RouteUtils {
    private static final Logger log = LoggerFactory.getLogger(RouteUtils.class);

    private RouteUtils() {
    }

    public static void initRoutes(ServiceMappingProperties serviceMappingProperties, BiConsumer<String, String> pathConsumer, BiConsumer<String, String> feignConsumer) {
        if (Objects.nonNull(serviceMappingProperties)) {
            String globalPrefix = serviceMappingProperties.getPathPrefix();
            Map<String, RouteConfig> routeConfigMap = serviceMappingProperties.getRoutes();
            if (ObjectUtils.nonNullOrEmpty(routeConfigMap)) {
                routeConfigMap.forEach((serviceId, routeConfig) -> RouteUtils.initRoute(serviceId, routeConfig, globalPrefix, pathConsumer, feignConsumer));
            }
        }
    }

    public static ServiceMappingProperties serviceMappingProperties(Environment environment) {
        BindResult result = Binder.get((Environment)environment).bind("zuul", ServiceMappingProperties.class);
        return result.isBound() ? (ServiceMappingProperties)result.get() : null;
    }

    public static void initRoute(String serviceId, RouteConfig routeConfig, String globalPrefix, BiConsumer<String, String> pathConsumer, BiConsumer<String, String> feignConsumer) {
        String feignName;
        log.debug("Init route config.");
        if (StringUtils.nonEmpty((CharSequence)routeConfig.getServiceId())) {
            serviceId = routeConfig.getServiceId();
        }
        if (StringUtils.isEmpty((CharSequence)(feignName = routeConfig.getName()))) {
            feignName = RouteUtils.defaultFeignName(serviceId);
        }
        feignConsumer.accept(feignName, serviceId);
        String pattern = routeConfig.getPath();
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            String prefix = routeConfig.getPrefix();
            if (StringUtils.isEmpty((CharSequence)prefix)) {
                prefix = globalPrefix;
            }
            pattern = prefix + feignName + "/**";
        }
        pathConsumer.accept(pattern, serviceId);
    }

    public static String defaultFeignName(String serviceId) {
        return serviceId.replaceAll("-", "/");
    }
}

