/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.feign;

import cn.com.yusys.yusp.commons.ribbon.RouteMappingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.lang.NonNull;

public class RouteFeignBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final Logger log = LoggerFactory.getLogger(RouteFeignBeanDefinitionRegistryPostProcessor.class);
    private final RouteMappingLocator routeMappingLocator;

    public RouteFeignBeanDefinitionRegistryPostProcessor(RouteMappingLocator routeMappingLocator) {
        this.routeMappingLocator = routeMappingLocator;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        for (String name : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(name);
            if (!"org.springframework.cloud.openfeign.FeignClientFactoryBean".equalsIgnoreCase(beanDefinition.getBeanClassName())) continue;
            MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
            String serviceId = this.getMappingService(mutablePropertyValues.get("name").toString());
            if (serviceId == null) {
                return;
            }
            mutablePropertyValues.add("name", (Object)serviceId);
            registry.removeBeanDefinition(name);
            registry.registerBeanDefinition(name, beanDefinition);
        }
    }

    private String getMappingService(String originService) {
        return this.routeMappingLocator.extractServiceIdByFeignName(originService);
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.log.debug("postProcessBeanFactory BeanFactory.");
    }
}

