/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.ribbon.config;

import cn.com.yusys.yusp.commons.ribbon.RouteMappingLocator;
import cn.com.yusys.yusp.commons.ribbon.config.ServiceMappingProperties;
import cn.com.yusys.yusp.commons.ribbon.util.RouteUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;

public class ConfigRouteMappingLocator
implements RouteMappingLocator {
    private static final Map<String, String> PATH_TO_SERVICES = new HashMap<String, String>();
    private static final Map<String, String> NAME_TO_SERVICES = new HashMap<String, String>();
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public ConfigRouteMappingLocator(ServiceMappingProperties properties) {
        this.initMappings(properties);
    }

    private void initMappings(ServiceMappingProperties properties) {
        RouteUtils.initRoutes(properties, PATH_TO_SERVICES::put, NAME_TO_SERVICES::put);
    }

    @Override
    public String extractServiceId(String path) {
        String adjustedPath = this.adjustPath(path);
        return PATH_TO_SERVICES.entrySet().stream().filter(entry -> this.antPathMatcher.match((String)entry.getKey(), adjustedPath)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @Override
    public String extractServiceIdByFeignName(@NonNull String name) {
        return NAME_TO_SERVICES.get(name);
    }

    private String adjustPath(String path) {
        return path;
    }
}

