/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.enchance;

import cn.com.yusys.yusp.commons.redis.EnhanceRedisCache;
import cn.com.yusys.yusp.commons.redis.enchance.CacheOpWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.DurationValueWrapper;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class EnhanceCacheTransactionSynchronization
extends TransactionSynchronizationAdapter {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceCacheTransactionSynchronization.class);
    private final EnhanceRedisCache targetCache;
    private final Map<Object, CacheOpWrapper> transactionCaches;

    public EnhanceCacheTransactionSynchronization(EnhanceRedisCache targetCache, Map<Object, CacheOpWrapper> transactionCaches) {
        this.targetCache = targetCache;
        this.transactionCaches = transactionCaches;
    }

    public void beforeCommit(boolean readOnly) {
        if (readOnly || this.transactionCaches.isEmpty()) {
            return;
        }
        for (CacheOpWrapper wrapper : this.filter(w -> w.getCacheOpType() == CacheOpWrapper.CacheOpType.REMOVE)) {
            String holderValue = RedisUtils.randomPrefix("@CACHE_UPDATE");
            DurationValueWrapper durationWrapper = new DurationValueWrapper(holderValue, "30S");
            this.targetCache.put(wrapper.getKey(), durationWrapper);
            wrapper.setCurrentValue(holderValue);
        }
    }

    public void afterCommit() {
        if (this.transactionCaches.isEmpty()) {
            return;
        }
        if (this.isClear()) {
            this.targetCache.clear();
            this.transactionCaches.clear();
            return;
        }
        logger.debug("writing values afterCommit.");
        for (CacheOpWrapper wrapper : this.filter(w -> w.getCacheOpType() == CacheOpWrapper.CacheOpType.READ_WRITE || w.getCacheOpType() == CacheOpWrapper.CacheOpType.REMOVE)) {
            try {
                this.targetCache.put(wrapper.getKey(), wrapper.casValue());
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Can't update cache [key = {}], [value = {}]; Exception message: {}", new Object[]{wrapper.getKey(), wrapper.get(), e.getMessage()});
            }
        }
        for (CacheOpWrapper wrapper : this.filter(w -> w.getCacheOpType() == CacheOpWrapper.CacheOpType.WRITE)) {
            try {
                this.targetCache.put(wrapper.getKey(), wrapper.get());
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Can't update cache [key = {}], [value = {}]; Exception message: {}", new Object[]{wrapper.getKey(), wrapper.get(), e.getMessage()});
            }
        }
    }

    public void afterCompletion(int status) {
        if (status != 0) {
            for (CacheOpWrapper wrapper : this.filter(w -> w.getCacheOpType() == CacheOpWrapper.CacheOpType.REMOVE)) {
                this.targetCache.put(wrapper.getKey(), wrapper.casValue());
            }
        }
        this.transactionCaches.clear();
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this.targetCache));
    }

    public void suspend() {
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this.targetCache));
    }

    public void resume() {
        TransactionSynchronizationManager.bindResource((Object)((Object)this.targetCache), this.transactionCaches);
    }

    private List<CacheOpWrapper> filter(Predicate<CacheOpWrapper> predicate) {
        if (this.transactionCaches.isEmpty()) {
            return Collections.emptyList();
        }
        return this.transactionCaches.values().stream().filter(predicate).filter(CacheOpWrapper::isNeedUpdate).collect(Collectors.toList());
    }

    public boolean isClear() {
        CacheOpWrapper wrapper = this.transactionCaches.get(this.targetCache.getName() + "##clear##");
        return wrapper != null && CacheOpWrapper.CacheOpType.CLEAR == wrapper.getCacheOpType();
    }
}

