/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.bloomfilter;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Resource;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;

public class BloomFilterString
implements CommandLineRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterString.class);
    private RBloomFilter<String> bloomFilter;
    @Resource
    private RedissonClient redissonClient;
    @Value(value="${yusp.cache.bloom-filter.capacity:10000000}")
    private long capacity;
    @Value(value="${yusp.cache.bloom-filter.errorRate:0.001}")
    private double errorRate;

    public void run(String ... args) throws Exception {
        this.bloomFilter = this.redissonClient.getBloomFilter("bloom-filter");
        this.bloomFilter.tryInit(this.capacity, this.errorRate);
        try {
            ArrayList usrIdList = new ArrayList();
            usrIdList.stream().map(Objects::toString).forEach(arg_0 -> this.bloomFilter.add(arg_0));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void put(String charSequence) {
        this.bloomFilter.add((Object)charSequence);
    }

    public boolean mightContain(String charSequence) {
        return this.bloomFilter.contains((Object)charSequence);
    }
}

