/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import cn.com.yusys.yusp.commons.redis.EnhanceRedisCache;
import cn.com.yusys.yusp.commons.redis.EnhanceRedisCacheManager;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.time.Duration;
import java.util.Map;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;

public class RedisCacheEnhanceManager
extends EnhanceRedisCacheManager {
    private static final String placeholderPrefix = "${";

    public RedisCacheEnhanceManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        super(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations);
    }

    @Override
    public EnhanceRedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        Duration duration;
        int index = name.lastIndexOf("@");
        if (index == -1 || index + 2 >= name.length()) {
            return new EnhanceRedisCache(name, this.getCacheWriter(), cacheConfig);
        }
        int configStartIndex = name.indexOf(placeholderPrefix);
        if (configStartIndex > -1) {
            duration = null;
        } else {
            String time = name.substring(index + 1);
            duration = RedisUtils.getDuration(time);
        }
        if (null == duration) {
            duration = cacheConfig.getTtl();
        }
        name = name.substring(0, index);
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(s -> s + ":").serializeKeysWith(cacheConfig.getKeySerializationPair()).serializeValuesWith(cacheConfig.getValueSerializationPair()).entryTtl(duration);
        return new EnhanceRedisCache(name, this.getCacheWriter(), config);
    }
}

