/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class EnvAwareCacheResolver
extends SimpleCacheResolver
implements EnvironmentAware,
ApplicationListener<EnvironmentChangeEvent> {
    private static final Logger logger = LoggerFactory.getLogger(EnvAwareCacheResolver.class);
    private static final String CACHE_KEY_PREFIX = "yusp.cache";
    private static final String CACHE_KEY_UPDATED = "";
    private static final String placeholderPrefix = "${";
    private static final String placeholderSuffix = "}";
    private static final String valueSeparator = ":";
    @Value(value="${yusp.cache.ttl:720}")
    private int ttl;
    private ConcurrentMap<String, String> cacheKeyMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> cacheNameToResolvedKeyMap = new HashMap<String, String>();
    private Environment environment;
    private ConcurrentMap<String, Cache> parentFieldCacheMap;

    public EnvAwareCacheResolver(CacheManager cacheManager) {
        super(cacheManager);
        Field f = ReflectionUtils.findField(cacheManager.getClass(), (String)"cacheMap");
        f.setAccessible(true);
        try {
            this.parentFieldCacheMap = (ConcurrentMap)f.get(cacheManager);
        }
        catch (IllegalAccessException e) {
            logger.warn("fail to get field[cacheMap] from org.springframework.cache.support.AbstractCacheManager : {}", (Object)e.getMessage());
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        Set changedKeys = event.getKeys();
        List changedCacheKeys = changedKeys.stream().filter(str -> str.contains(CACHE_KEY_PREFIX)).map(key -> {
            this.cacheKeyMap.put((String)key, CACHE_KEY_UPDATED);
            return key;
        }).collect(Collectors.toList());
        logger.info("update config key of cacheNames[{}]", changedCacheKeys);
    }

    protected Collection<String> getCacheNames(CacheOperationInvocationContext<?> context) {
        Collection cacheNames = super.getCacheNames(context);
        return cacheNames.stream().map(cacheName -> {
            String resolvedKey;
            int configStartIndex = cacheName.indexOf(placeholderPrefix);
            if (configStartIndex == -1) {
                return cacheName;
            }
            int configEndIndex = cacheName.indexOf(placeholderSuffix);
            String configKey = cacheName.substring(configStartIndex + placeholderPrefix.length(), cacheName.indexOf(valueSeparator));
            String configExp = cacheName.substring(configStartIndex, configEndIndex + 1);
            String cacheKeyVal = (String)this.cacheKeyMap.get(configKey);
            if (cacheKeyVal == null) {
                String timeConfigStr = this.getConfigFromEnv(configExp);
                this.cacheKeyMap.put(configKey, timeConfigStr);
                resolvedKey = new StringBuilder((String)cacheName).replace(configStartIndex, configEndIndex + 1, timeConfigStr).toString();
                this.cacheNameToResolvedKeyMap.put((String)cacheName, resolvedKey);
            } else if (CACHE_KEY_UPDATED.equals(cacheKeyVal)) {
                String timeConfigStr = this.getConfigFromEnv(configExp);
                this.cacheKeyMap.put(configKey, timeConfigStr);
                resolvedKey = new StringBuilder((String)cacheName).replace(configStartIndex, configEndIndex + 1, timeConfigStr).toString();
                String oldResolvedKey = this.cacheNameToResolvedKeyMap.get(cacheName);
                this.parentFieldCacheMap.remove(oldResolvedKey);
                logger.info("remove old cacheName[{}] - [{}]", cacheName, (Object)oldResolvedKey);
                this.cacheNameToResolvedKeyMap.put((String)cacheName, resolvedKey);
            } else {
                resolvedKey = new StringBuilder((String)cacheName).replace(configStartIndex, configEndIndex + 1, cacheKeyVal).toString();
            }
            logger.debug("set cacheNames from [{}] to [{}]", cacheName, (Object)resolvedKey);
            return resolvedKey;
        }).collect(Collectors.toList());
    }

    private String getConfigFromEnv(String configExp) {
        String timeConfigStr = this.environment.resolvePlaceholders(configExp);
        if (!StringUtils.hasText((String)timeConfigStr)) {
            logger.info("read config key[{}] empty, use default config : {} ", (Object)configExp, (Object)this.ttl);
            timeConfigStr = String.valueOf(this.ttl * 60);
        } else if (timeConfigStr.contains(placeholderPrefix)) {
            logger.info("read config key[{}] fail, use default config : {} ", (Object)configExp, (Object)this.ttl);
            timeConfigStr = String.valueOf(this.ttl * 60);
        }
        return timeConfigStr;
    }
}

