/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import cn.com.yusys.yusp.commons.redis.EnhanceRedisCacheLuaScript;
import cn.com.yusys.yusp.commons.redis.EnhanceRedisCacheWriter;
import cn.com.yusys.yusp.commons.redis.enchance.CasValueWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.DurationValueWrapper;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.core.script.DigestUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class EnhanceRedisCache
extends RedisCache {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceRedisCache.class);
    private ConversionService conversionService;

    public EnhanceRedisCache(String name, RedisCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
        super(name, cacheWriter, cacheConfig);
        this.conversionService = cacheConfig.getConversionService();
    }

    public void put(Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (cacheValue == null) {
            return;
        }
        EnhanceRedisCacheWriter writer = (EnhanceRedisCacheWriter)this.getNativeCache();
        String cacheKey = this.createCacheKey(key);
        if (cacheValue instanceof CasValueWrapper) {
            CasValueWrapper casValue = (CasValueWrapper)cacheValue;
            Object expectValue = casValue.getExpectValue();
            cacheValue = casValue.get();
            if (expectValue != null) {
                byte[][] keysAndArgs = new byte[][]{this.serializeCacheKey(cacheKey), this.serializeCacheValue(cacheValue), this.serializeCacheValue(expectValue)};
                Duration time = this.getCacheConfiguration().getTtl();
                if (cacheValue instanceof String && cacheValue.toString().startsWith("@CACHE_EVICT")) {
                    time = RedisUtils.getDuration("30S");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("casPut into cache[key={}, value={}, expectValue={}]", new Object[]{key, cacheValue, expectValue});
                }
                String sha1 = DigestUtils.sha1DigestAsHex((String)"local v1 = redis.call('get',KEYS[1])\nif (v1 == ARGV[2]) then \n    redis.call('set',KEYS[1],ARGV[1])\nend\n");
                writer.casPut(this.getName(), EnhanceRedisCacheLuaScript.scriptBytes(sha1), EnhanceRedisCacheLuaScript.scriptBytes("local v1 = redis.call('get',KEYS[1])\nif (v1 == ARGV[2]) then \n    redis.call('set',KEYS[1],ARGV[1])\nend\n"), time, keysAndArgs);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("putIfAbsent value into cache[key={}, value={}]", key, cacheValue);
                }
                writer.putIfAbsent(this.getName(), this.serializeCacheKey(cacheKey), this.serializeCacheValue(cacheValue), this.getCacheConfiguration().getTtl());
            }
        } else if (cacheValue instanceof DurationValueWrapper) {
            DurationValueWrapper durationValue = (DurationValueWrapper)cacheValue;
            Duration ttl = RedisUtils.getDuration(durationValue.getDuration());
            writer.put(this.getName(), this.serializeCacheKey(cacheKey), this.serializeCacheValue(durationValue.get()), ttl);
        } else {
            writer.put(this.getName(), this.serializeCacheKey(cacheKey), this.serializeCacheValue(cacheValue), this.getCacheConfiguration().getTtl());
        }
    }

    public String convertKey(Object key) {
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        if (this.conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
            return (String)this.conversionService.convert(key, String.class);
        }
        Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
        if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
            return key.toString();
        }
        throw new IllegalStateException(String.format("Cannot convert %s to String. Register a Converter or override toString().", source));
    }
}

