/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import cn.com.yusys.yusp.commons.redis.EnhanceRedisCache;
import cn.com.yusys.yusp.commons.redis.enchance.EnhanceCacheDecorator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.util.Assert;

public class EnhanceRedisCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final RedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration defaultCacheConfig;
    private final Map<String, RedisCacheConfiguration> initialCacheConfiguration;

    protected Cache decorateCache(Cache cache) {
        return new EnhanceCacheDecorator(cache);
    }

    private EnhanceRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
        this.initialCacheConfiguration = new LinkedHashMap<String, RedisCacheConfiguration>();
    }

    public EnhanceRedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        this(cacheWriter, defaultCacheConfiguration);
        Assert.notNull(initialCacheConfigurations, (String)"InitialCacheConfigurations must not be null!");
        this.initialCacheConfiguration.putAll(initialCacheConfigurations);
    }

    protected Collection<RedisCache> loadCaches() {
        return new LinkedList<RedisCache>();
    }

    protected RedisCache getMissingCache(String name) {
        return this.createRedisCache(name, this.defaultCacheConfig);
    }

    public EnhanceRedisCache createRedisCache(String name, RedisCacheConfiguration cacheConfig) {
        return new EnhanceRedisCache(name, this.cacheWriter, cacheConfig);
    }

    public RedisCacheWriter getCacheWriter() {
        return this.cacheWriter;
    }
}

