/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis.enchance;

import cn.com.yusys.yusp.commons.redis.YuspRedisCache;
import cn.com.yusys.yusp.commons.redis.enchance.AbsentValueWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.CacheOpThreadLocal;
import cn.com.yusys.yusp.commons.redis.enchance.CacheOpWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.CasValueWrapper;
import cn.com.yusys.yusp.commons.redis.enchance.DurationValueWrapper;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class YuspCacheTransactionSynchronization
extends TransactionSynchronizationAdapter {
    private static final Logger logger = LoggerFactory.getLogger(YuspCacheTransactionSynchronization.class);
    private final YuspRedisCache targetCache;
    private final Map<String, CacheOpWrapper> transactionCaches;

    public YuspCacheTransactionSynchronization(YuspRedisCache targetCache, Map<String, CacheOpWrapper> transactionCaches) {
        this.targetCache = targetCache;
        this.transactionCaches = transactionCaches;
    }

    public void beforeCommit(boolean readOnly) {
        if (readOnly || this.transactionCaches.isEmpty()) {
            return;
        }
        Map<Object, Object> valuesRead = this.filter(CacheOpWrapper.CacheOpType.READ);
        for (Map.Entry<Object, Object> entry : valuesRead.entrySet()) {
            if (entry.getValue() == null) continue;
            AbsentValueWrapper absentValueWrapper = new AbsentValueWrapper(entry.getValue());
            CacheOpWrapper cacheOpT = new CacheOpWrapper(this.targetCache.getName(), absentValueWrapper, CacheOpWrapper.CacheOpType.READ, true);
            this.transactionCaches.put(this.targetCache.getRealKey(entry.getKey()), cacheOpT);
        }
        Map<Object, Object> valuesWrite = this.filter(CacheOpWrapper.CacheOpType.WRITE);
        for (Map.Entry entry : valuesWrite.entrySet()) {
            String holderValue = RedisUtils.randomPrefix("@CACHE_UPDATE");
            DurationValueWrapper durationWrapper = new DurationValueWrapper(holderValue, "30S");
            this.targetCache.put(entry.getKey(), durationWrapper);
            if (entry.getValue() == null) continue;
            CasValueWrapper newValue = CasValueWrapper.of(holderValue).newValue(entry.getValue());
            CacheOpWrapper wrapper = new CacheOpWrapper(this.targetCache.getName(), newValue, CacheOpWrapper.CacheOpType.WRITE, true);
            this.transactionCaches.put(this.targetCache.getRealKey(entry.getKey()), wrapper);
        }
        Map<Object, Object> values = this.filter(CacheOpWrapper.CacheOpType.REMOVE);
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            String holderValue = RedisUtils.randomPrefix("@CACHE_EVICT");
            String reValue = RedisUtils.randomPrefix("@CACHE_EVICT");
            DurationValueWrapper durationWrapper = new DurationValueWrapper(holderValue, "30S");
            this.targetCache.put(entry.getKey(), durationWrapper);
            CasValueWrapper newValue = CasValueWrapper.of(holderValue).newValue(reValue);
            CacheOpWrapper wrapper = new CacheOpWrapper(this.targetCache.getName(), newValue, CacheOpWrapper.CacheOpType.REMOVE, true);
            this.transactionCaches.put(this.targetCache.getRealKey(entry.getKey()), wrapper);
        }
    }

    public void afterCommit() {
        if (this.transactionCaches.isEmpty()) {
            return;
        }
        if (this.isClear()) {
            this.targetCache.clear();
            this.transactionCaches.clear();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("writing values afterCommit.");
        }
        Stream.concat(this.filter(CacheOpWrapper.CacheOpType.READ).entrySet().stream(), Stream.concat(this.filter(CacheOpWrapper.CacheOpType.WRITE).entrySet().stream(), this.filter(CacheOpWrapper.CacheOpType.REMOVE).entrySet().stream().filter((? super T e) -> e.getValue() != null))).forEach(entry -> {
            block2: {
                try {
                    this.targetCache.put(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn("Can't update cache [key = {}] , [value = {}] ", new Object[]{entry.getKey(), entry.getValue(), e});
                }
            }
        });
    }

    public void afterCompletion(int status) {
        Map<Object, Object> values = this.filter(CacheOpWrapper.CacheOpType.REMOVE);
        for (Map.Entry<Object, Object> entry : values.entrySet()) {
            if (status == 0 && entry.getValue() != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Setting evict holder value to cache[key = {}] afterCompletion.", entry.getKey());
            }
            String holderValue = RedisUtils.randomPrefix("@CACHE_EVICT");
            DurationValueWrapper durationWrapper = new DurationValueWrapper(holderValue, "30S");
            this.targetCache.put(entry.getKey(), durationWrapper);
        }
        this.transactionCaches.clear();
        CacheOpThreadLocal.CacheOps.remove();
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this.targetCache));
    }

    public void suspend() {
        CacheOpThreadLocal.CacheOps.remove();
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)((Object)this.targetCache));
    }

    public void resume() {
        TransactionSynchronizationManager.bindResource((Object)((Object)this.targetCache), (Object)true);
    }

    private Map<Object, Object> filter(CacheOpWrapper.CacheOpType cacheOpType) {
        Map<String, CacheOpWrapper> cacheOps = this.transactionCaches;
        if (cacheOps.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Map.Entry<String, CacheOpWrapper> entry : cacheOps.entrySet()) {
            CacheOpWrapper value = entry.getValue();
            if (cacheOpType != value.getCacheOpType() || !this.targetCache.getName().equals(value.getCacheName()) || cacheOpType == CacheOpWrapper.CacheOpType.READ && !value.isOp()) continue;
            String strKey = entry.getKey().substring(this.targetCache.getName().length() + ":".length());
            result.put(strKey, value.getValue());
        }
        return result;
    }

    public boolean isClear() {
        CacheOpWrapper wrapper = this.transactionCaches.get(this.targetCache.getName() + ":");
        return wrapper != null && CacheOpWrapper.CacheOpType.CLEAR == wrapper.get();
    }
}

