/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.redis;

import cn.com.yusys.yusp.commons.redis.YuspRedisCache;
import cn.com.yusys.yusp.commons.redis.YuspRedisCacheManager;
import cn.com.yusys.yusp.commons.redis.util.RedisUtils;
import java.time.Duration;
import java.util.Map;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.lang.Nullable;

public class YuspRedisCacheEnchanceManager
extends YuspRedisCacheManager {
    public YuspRedisCacheEnchanceManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations, boolean allowInFlightCacheCreation) {
        super(cacheWriter, defaultCacheConfiguration, initialCacheConfigurations, allowInFlightCacheCreation);
    }

    @Override
    protected YuspRedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        int index = name.lastIndexOf("@");
        if (index == -1 || index + 2 >= name.length()) {
            return new YuspRedisCache(name, this.getCacheWriter(), cacheConfig != null ? cacheConfig : this.getDefaultCacheConfig());
        }
        String time = name.substring(index + 1);
        Duration duration = RedisUtils.getDuration(time);
        if (cacheConfig == null) {
            cacheConfig = this.getDefaultCacheConfig();
        }
        if (duration == null) {
            duration = cacheConfig.getTtl();
        }
        name = name.substring(0, index);
        RedisCacheConfiguration config = RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(cacheConfig.getKeySerializationPair()).serializeValuesWith(cacheConfig.getValueSerializationPair()).entryTtl(duration);
        return new YuspRedisCache(name, this.getCacheWriter(), config);
    }
}

