/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.progress;

import cn.com.yusys.yusp.commons.progress.IProgress;
import cn.com.yusys.yusp.commons.progress.model.ProgressDto;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class ProgressPushService
implements IProgress {
    private static final Logger logger = LoggerFactory.getLogger(ProgressPushService.class);
    public static final String ATTR_PROGRESS_ID = "progressId";
    public static final String ATTR_CURRENT_VALUE = "currentValue";
    public static final String ATTR_MAX_VALUE = "maxValue";
    public static final String ATTR_MESSAGE = "message";
    public static final String ATTR_STATUS = "status";
    public static final int DEFAULT_MAX_VALUE = 100;
    public static final String STATUS_OK = "ok";
    public static final String STATUS_FAIL = "fail";
    private static final String KEY_PREFIX = "notification.progress.";
    private HashOperations<String, String, Object> hashOperation;

    public ProgressPushService(RedisTemplate<String, Object> redisTemplate) {
        this.hashOperation = redisTemplate.opsForHash();
    }

    public Map<String, Object> getProgressInfo(String progressId) {
        String key = this.getKey(progressId);
        return this.hashOperation.entries((Object)key);
    }

    public void set(String taskId, ProgressDto progressDto) {
    }

    public void report(String progressId, int value) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put(ATTR_CURRENT_VALUE, value);
        this.reportInternal(progressId, datas);
    }

    public void report(String progressId, int value, int maxValue) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put(ATTR_CURRENT_VALUE, value);
        datas.put(ATTR_MAX_VALUE, maxValue);
        this.reportInternal(progressId, datas);
    }

    public void report(String progressId, int value, int maxValue, String message) {
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put(ATTR_CURRENT_VALUE, value);
        datas.put(ATTR_MAX_VALUE, maxValue);
        datas.put(ATTR_MESSAGE, message);
        this.reportInternal(progressId, datas);
    }

    public void report(String progressId, int value, int maxValue, Map<String, Object> attributes) {
        HashMap<String, Object> datas = new HashMap<String, Object>(attributes);
        datas.put(ATTR_CURRENT_VALUE, value);
        datas.put(ATTR_MAX_VALUE, maxValue);
        this.reportInternal(progressId, datas);
    }

    public void reportIncrement(String progressId, int incrementValue) {
        String key = this.getKey(progressId);
        this.hashOperation.increment((Object)key, (Object)ATTR_CURRENT_VALUE, (long)incrementValue);
    }

    public void reportFailed(String progressId, String message) {
        String key = this.getKey(progressId);
        this.hashOperation.put((Object)key, (Object)ATTR_STATUS, (Object)STATUS_FAIL);
        this.hashOperation.put((Object)key, (Object)ATTR_MESSAGE, (Object)message);
        this.expire(key);
    }

    public ProgressDto progress(String taskId) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            logger.warn("the task id is blank. please check.");
            return null;
        }
        String key = this.getKey(taskId);
        Map entries = this.hashOperation.entries((Object)key);
        ProgressDto progressDto = (ProgressDto)ObjectMapperUtils.instance().convertValue((Object)entries, ProgressDto.class);
        return progressDto;
    }

    private void reportInternal(String progressId, Map<String, Object> attributes) {
        String key = this.getKey(progressId);
        Map redisData = this.hashOperation.entries((Object)key);
        redisData.putAll(attributes);
        redisData.putIfAbsent(ATTR_STATUS, STATUS_OK);
        this.hashOperation.putAll((Object)key, redisData);
        this.expire(key);
    }

    private void expire(String key) {
        this.hashOperation.getOperations().expire((Object)key, 12L, TimeUnit.HOURS);
    }

    private String getKey(String progressId) {
        return KEY_PREFIX + progressId;
    }
}

