/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.openfeign.util;

import cn.com.yusys.yusp.commons.openfeign.exception.FeignInvokeException;
import cn.com.yusys.yusp.commons.openfeign.mock.store.FeignInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class FeignUtils {
    private static final Logger logger = LoggerFactory.getLogger(FeignUtils.class);

    private FeignUtils() {
    }

    private static String getPath(Object target) {
        FeignClient feignClient = FeignUtils.getFeignAnna(target);
        String name = String.valueOf(AnnotationUtils.getValue((Annotation)feignClient));
        String path = feignClient.path();
        return name + path;
    }

    public static FeignInfo feignInfo(Object target, Method method) {
        FeignInfo feignInfo = new FeignInfo();
        feignInfo.setBasePath(FeignUtils.getPath(target));
        RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        Objects.requireNonNull(requestMapping);
        Object[] paths = (String[])AnnotationUtils.getValue((Annotation)requestMapping);
        String path = "";
        if (paths != null && paths.length == 1) {
            path = paths[0];
        } else if (paths != null && paths.length > 1) {
            throw new FeignInvokeException(String.format("FeignClient method: %s exist multi paths: %s", method.getName(), Arrays.toString(paths)));
        }
        feignInfo.setPath(path);
        Object[] methods = requestMapping.method();
        RequestMethod requestMethod = null;
        if (methods.length == 1) {
            requestMethod = methods[0];
        } else if (methods.length > 1) {
            throw new FeignInvokeException(String.format("FeignClient method: %s exist multi methods: %s.", method.getName(), Arrays.toString(methods)));
        }
        feignInfo.setMethod(requestMethod);
        return feignInfo;
    }

    public static boolean isFeign(Object proxy) {
        Object[] proxyInterfaces = FeignUtils.getInterfaces(proxy);
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ee3\u7406\u5bf9\u8c61\u7684\u63a5\u53e3\u5217\u8868:{}", (Object)Arrays.toString(proxyInterfaces));
        }
        if (proxyInterfaces.length > 0) {
            for (Object proxyInterface : proxyInterfaces) {
                if (!((Class)proxyInterface).isAnnotationPresent(FeignClient.class)) continue;
                FeignClient feignClient = ((Class)proxyInterface).getAnnotation(FeignClient.class);
                Class fallback = feignClient.fallback();
                if (fallback != Void.TYPE && fallback.isAssignableFrom(proxy.getClass())) {
                    logger.debug("Fallback impl not proxy interceptor");
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static FeignClient getFeignAnna(Object proxy) {
        Object[] proxyInterfaces = FeignUtils.getInterfaces(proxy);
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ee3\u7406\u5bf9\u8c61\u7684\u63a5\u53e3\u5217\u8868:{}", (Object)Arrays.toString(proxyInterfaces));
        }
        if (proxyInterfaces.length > 0) {
            for (Object proxyInterface : proxyInterfaces) {
                FeignClient feignClientAnna = (FeignClient)AnnotationUtils.findAnnotation((Class)proxyInterface, FeignClient.class);
                if (feignClientAnna == null) continue;
                return feignClientAnna;
            }
        }
        throw new FeignInvokeException("Missing @FeignClient!");
    }

    private static Class<?>[] getInterfaces(Object proxy) {
        return proxy.getClass().getInterfaces();
    }
}

