/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.openfeign.mock;

import cn.com.yusys.yusp.commons.openfeign.exception.FeignInvokeException;
import cn.com.yusys.yusp.commons.openfeign.interceptor.FeignInterceptor;
import cn.com.yusys.yusp.commons.openfeign.mock.FeignMockStrategy;
import cn.com.yusys.yusp.commons.openfeign.mock.store.FeignInfo;
import cn.com.yusys.yusp.commons.openfeign.mock.store.MockData;
import cn.com.yusys.yusp.commons.openfeign.mock.store.MockDataStore;
import cn.com.yusys.yusp.commons.openfeign.util.FeignUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MockInterceptor
implements FeignInterceptor {
    private MockDataStore mockDataStore;
    private FeignMockStrategy mockStrategy;

    public MockInterceptor(MockDataStore mockDataStore, FeignMockStrategy mockStrategy) {
        this.mockDataStore = mockDataStore;
        this.mockStrategy = mockStrategy;
    }

    @Override
    public Object intercept(Object target, Method method, Object[] args) throws FeignInvokeException {
        FeignInfo feignInfo = this.extract(target, method);
        if (this.mockStrategy.needMock(feignInfo, args)) {
            return this.convert(this.fetchMock(feignInfo), method);
        }
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FeignInvokeException("Invoke Feign Client exception", e);
        }
    }

    private FeignInfo extract(Object target, Method method) throws FeignInvokeException {
        return FeignUtils.feignInfo(target, method);
    }

    private MockData fetchMock(FeignInfo feignInfo) throws FeignInvokeException {
        MockData<?> mockData = this.mockDataStore.findOneByUrl(feignInfo.url(), feignInfo.getMethod());
        if (mockData == null) {
            throw new FeignInvokeException(String.format("Cannot Fetch MockData: url: %s,method: %s", feignInfo.url(), feignInfo.getMethod()));
        }
        return mockData;
    }

    private Object convert(MockData mockData, Method method) {
        return this.mockStrategy.convert(mockData, method.getReturnType());
    }
}

