/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.sender;

import cn.com.yusys.yusp.commons.biz.BizHandlerInterceptor;
import cn.com.yusys.yusp.commons.oplog.OpLog;
import cn.com.yusys.yusp.commons.oplog.annotation.OpLogAdd;
import cn.com.yusys.yusp.commons.oplog.oplog.IOpLogSender;
import cn.com.yusys.yusp.commons.oplog.sender.OpLogFilter;
import cn.com.yusys.yusp.commons.oplog.util.OnlineLogUtils;
import java.util.Optional;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OpLogHandlerInterceptor
implements BizHandlerInterceptor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(OpLogHandlerInterceptor.class);
    private final IOpLogSender logSender;
    private final OpLogFilter filter;
    private final Boolean annotationEnabled;
    private final Boolean matchEnabled;

    public OpLogHandlerInterceptor(IOpLogSender logSender, Boolean annotationEnabled, Boolean matchEnabled, Set<String> urlFormats, Set<String> ignoreUrlFormats) {
        this.logSender = logSender;
        this.annotationEnabled = annotationEnabled;
        this.matchEnabled = matchEnabled;
        this.filter = new OpLogFilter(urlFormats, ignoreUrlFormats);
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Boolean send = false;
        if (this.annotationEnabled.booleanValue()) {
            OpLogAdd logAdd = methodInvocation.getMethod().getAnnotation(OpLogAdd.class);
            if (ObjectUtils.isEmpty((Object)logAdd)) {
                logAdd = methodInvocation.getMethod().getDeclaringClass().getAnnotation(OpLogAdd.class);
            }
            if (!ObjectUtils.isEmpty((Object)logAdd)) {
                if (!logAdd.enabled()) {
                    return methodInvocation.proceed();
                }
                send = true;
            }
        }
        if (send.booleanValue() || this.matchEnabled.booleanValue() && this.isUrlMatch()) {
            try {
                OpLog opLog = OnlineLogUtils.createOpLog(methodInvocation.getMethod().getName());
                this.logSender.send(opLog);
            }
            catch (Exception e) {
                LOG.error("send operation online log failed.", (Throwable)e);
            }
        }
        return methodInvocation.proceed();
    }

    private boolean isUrlMatch() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(ServletRequestAttributes.class::cast).map(attr -> attr.getRequest().getRequestURI()).map(this.filter::match).orElse(false);
    }

    public int getOrder() {
        return 10;
    }
}

