/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.util;

import cn.com.yusys.yusp.commons.biz.bizlog.BizExceptionLog;
import cn.com.yusys.yusp.commons.oplog.OpLog;
import cn.com.yusys.yusp.commons.oplog.context.OpLogContext;
import cn.com.yusys.yusp.commons.oplog.context.OpLogJobTaskContext;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public class OnlineLogUtils {
    private static final String DEFAULT_MEM_NUM = "0000000";

    public static BizExceptionLog createBizLog(String funcNum, String bizTradeNum, String excepDesc) {
        BizExceptionLog bizLog = new BizExceptionLog();
        OnlineLogUtils.fillContextInfo(bizLog, false);
        bizLog.setFuncNum(funcNum);
        bizLog.setBizTradeNum(bizTradeNum);
        bizLog.setExcepDesc(excepDesc);
        bizLog.setInputTm(DateUtils.getCurrDateTimeStr());
        return bizLog;
    }

    public static OpLog createOpLog(String functionName) {
        if (StringUtils.isEmpty((Object)functionName)) {
            throw new IllegalArgumentException("functionName is empty");
        }
        OpLog opLog = new OpLog();
        OnlineLogUtils.fillContextInfo(opLog, false);
        opLog.setOpTime(DateUtils.getCurrDateTimeStr());
        opLog.setFunctionName(functionName);
        return opLog;
    }

    public static void fillContextInfo(OpLog opLog, boolean throwIfNoContext) {
        OnlineLogUtils.fillContextInfo(opLog::setOperNum, opLog::setOperName, opLog::setMemAcctNum, throwIfNoContext);
    }

    public static void fillContextInfo(BizExceptionLog bizLog, boolean throwIfNoContext) {
        boolean filled = OnlineLogUtils.fillContextInfo(arg_0 -> ((BizExceptionLog)bizLog).setInputOperNum(arg_0), arg_0 -> ((BizExceptionLog)bizLog).setInputOperName(arg_0), arg_0 -> ((BizExceptionLog)bizLog).setMemAcctNum(arg_0), throwIfNoContext);
        if (filled) {
            bizLog.setBelongPltfrmCode(SpringContextUtils.getDomain());
        }
    }

    private static boolean fillContextInfo(Consumer<String> operNumSetter, Consumer<String> operNameSetter, Consumer<String> memNumSetter, boolean throwIfNoContext) {
        if (OpLogContext.exists()) {
            OpLogContext context = OpLogContext.get();
            operNumSetter.accept(context.getOperNum());
            operNameSetter.accept(context.getOperName());
            memNumSetter.accept(context.getMemNum());
            return true;
        }
        if (OpLogJobTaskContext.exists()) {
            OpLogJobTaskContext jobContext = OpLogJobTaskContext.get();
            operNumSetter.accept(jobContext.getOperNum());
            operNameSetter.accept(jobContext.getOperName());
            memNumSetter.accept(DEFAULT_MEM_NUM);
            return true;
        }
        if (throwIfNoContext) {
            throw new IllegalStateException("Not find context for online log");
        }
        return false;
    }

    private OnlineLogUtils() {
    }
}

