/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.oplog.listener;

import cn.com.yusys.yusp.commons.oplog.OpLog;
import cn.com.yusys.yusp.commons.oplog.oplog.IOpLogProcessor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;

public class OpLogListener {
    private static final Logger log = LoggerFactory.getLogger(OpLogListener.class);
    private final IOpLogProcessor logProcess;

    public OpLogListener(IOpLogProcessor logProcess) {
        this.logProcess = logProcess;
    }

    @RabbitHandler
    @RabbitListener(queues={"online-oplog"}, containerFactory="logRabbitListener")
    public void process(List<OpLog> dto, Message message) {
        if (log.isDebugEnabled()) {
            Map headers = message.getMessageProperties().getHeaders();
            log.debug("processing operation log, size:{}, from app:{}, ip:{},OpLog function:{}.", new Object[]{dto.size(), headers.get("log-request-app"), headers.get("log-request-ip"), dto.stream().map(OpLog::getFunctionName).collect(Collectors.joining(","))});
        }
        this.logProcess.process(dto);
    }
}

