/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.notification.api;

import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.notification.api.INotification;
import cn.com.yusys.yusp.notification.api.WindowMessageContent;
import cn.com.yusys.yusp.notification.exception.NotificationException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class NotificationeInfo
implements INotification {
    public static final String TYPE_NOTICE = "#NOTE#";
    public static final String TYPE_WINDOW = "#WINDOW#";
    public static final String TYPE_REPLY = "#REPLY#";
    public static final String LEVEL_SUCC = "success";
    public static final String LEVEL_WARN = "warning";
    public static final String LEVEL_INFO = "info";
    public static final String LEVEL_ERR = "error";
    private String type = "#NOTE#";
    private String title;
    private String level;
    private String desc;
    private String noticeTime;
    private Object notification;

    public NotificationeInfo() {
    }

    public NotificationeInfo(String title, String desc, String notification) {
        this.type = TYPE_NOTICE;
        this.level = LEVEL_INFO;
        this.title = title;
        this.desc = desc;
        this.notification = notification;
        this.noticeTime = DateUtils.getCurrDateTimeStr();
    }

    public NotificationeInfo(String title, String desc, WindowMessageContent content) {
        this.type = TYPE_WINDOW;
        this.level = LEVEL_INFO;
        this.title = title;
        this.desc = desc;
        this.notification = content;
        this.noticeTime = DateUtils.getCurrDateTimeStr();
    }

    @Override
    @JsonIgnore
    public String getPayload() {
        String writeValueAsString;
        ObjectMapper mapper = new ObjectMapper();
        try {
            writeValueAsString = mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new NotificationException(e.getMessage(), e);
        }
        return writeValueAsString;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getNoticeTime() {
        return this.noticeTime;
    }

    public void setNoticeTime(String noticeTime) {
        this.noticeTime = noticeTime;
    }

    public Object getNotification() {
        return this.notification;
    }

    public void setNotification(Object notification) {
        this.notification = notification;
    }
}

