/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.notification.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.notification.exception.NotificationException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdWorker {
    private static final Logger logger = LoggerFactory.getLogger(IdWorker.class);
    private static final long TWEPOCH = 1483200660000L;
    private static final long WORKERIDBITS = 5L;
    private static final long DATACENTERIDBITS = 5L;
    private static final long MAXWORKERID = 31L;
    private static final long MAXDATACENTERID = 31L;
    private static final long SEQUENCEBITS = 12L;
    private static final long WORKERIDSHIFT = 12L;
    private static final long DATACENTERIDSHIFT = 17L;
    private static final long TIMESTAMPLEFTSHIFT = 22L;
    private static final long SEQUENCEMASK = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public IdWorker() {
        this.datacenterId = IdWorker.getDatacenterId(31L);
        this.workerId = IdWorker.getMaxWorkerId(this.datacenterId, 31L);
    }

    public IdWorker(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public static long getDateTime(String strDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-mm-dd");
        Date date = format.parse(strDate);
        return date.getTime();
    }

    protected static long getDatacenterId(long maxDatacenterId) {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                    id %= maxDatacenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            logger.warn(" getDatacenterId: {}", (Object)e.getMessage(), (Object)e);
        }
        return id;
    }

    protected static long getMaxWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!StringUtils.isBlank((CharSequence)name)) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new NotificationException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tiNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1483200660000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    protected long tiNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }
}

