/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.notification.repo;

import cn.com.yusys.yusp.commons.redis.template.EnhanceRedisTemplate;
import cn.com.yusys.yusp.notification.api.IOperationAdapter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class RedisOperation
implements IOperationAdapter {
    @Autowired
    private EnhanceRedisTemplate yuspRedisTemplate;

    @Override
    public Long increment(String key) {
        return this.yuspRedisTemplate.incr(key);
    }

    @Override
    public Long increment(String key, String field) {
        return this.yuspRedisTemplate.incr(key, field);
    }

    @Override
    public void set(String key, String value) {
        this.yuspRedisTemplate.set(key, (Object)value);
    }

    @Override
    public void set(String key, String value, int timeoutSeconds) {
        this.yuspRedisTemplate.set(key, (Object)value, (long)timeoutSeconds);
    }

    @Override
    public void set(String key, Map<String, Object> map, int timeoutSeconds) {
        this.yuspRedisTemplate.hmset(key, map, (long)timeoutSeconds);
    }

    @Override
    public Boolean setIfAbsent(String key, String value) {
        return this.yuspRedisTemplate.setNx(key, (Object)value);
    }

    @Override
    public Boolean setIfAbsent(String key, String field, String value) {
        return this.yuspRedisTemplate.hsetnx(key, field, value);
    }

    @Override
    public Boolean setIfExists(String key, String field, String value) {
        return this.yuspRedisTemplate.hsetxx(key, field, value) == 1L;
    }

    @Override
    public String get(String key) {
        Object object = this.yuspRedisTemplate.get(key);
        if (object != null) {
            return String.valueOf(object);
        }
        return null;
    }

    @Override
    public String get(String key, String field) {
        Object hget = this.yuspRedisTemplate.hget(key, field);
        if (hget != null) {
            return String.valueOf(hget);
        }
        return null;
    }

    @Override
    public void delete(String key) {
        this.yuspRedisTemplate.del(new String[]{key});
    }

    @Override
    public void delete(String key, String field) {
        this.yuspRedisTemplate.hdel(key, new Object[]{field});
    }

    @Override
    public void set(String key, String field, String value) {
        if (value == null) {
            this.yuspRedisTemplate.hdel(key, new Object[]{field});
        } else {
            this.yuspRedisTemplate.hset(key, field, (Object)value);
        }
    }

    @Override
    public void set(String key, String field, String value, int timeoutSeconds) {
        if (value == null) {
            this.yuspRedisTemplate.hdel(key, new Object[]{field});
        } else {
            this.yuspRedisTemplate.hset(key, field, (Object)value);
            this.yuspRedisTemplate.expire(key, (long)timeoutSeconds);
        }
    }

    @Override
    public Set<String> fields(String key) {
        Set sGet = this.yuspRedisTemplate.sGet(key);
        HashSet<String> setStr = new HashSet<String>();
        if (sGet != null) {
            for (Object next : sGet) {
                setStr.add(String.valueOf(next));
            }
        }
        return setStr;
    }

    @Override
    public Map<String, String> getHash(String key) {
        Map hmget = this.yuspRedisTemplate.hmget(key);
        ConcurrentHashMap<String, String> mapStr = new ConcurrentHashMap<String, String>();
        for (Map.Entry entry : hmget.entrySet()) {
            Object mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            mapStr.put(String.valueOf(mapKey), String.valueOf(mapValue));
        }
        return mapStr;
    }

    @Override
    public String lpop(int timeout, String key) {
        if (timeout >= 0) {
            return this.yuspRedisTemplate.blpop(key, timeout);
        }
        return this.yuspRedisTemplate.lpop(key);
    }

    @Override
    public String rpop(int timeout, String key) {
        if (timeout >= 0) {
            return this.yuspRedisTemplate.brpop(key, timeout);
        }
        return this.yuspRedisTemplate.rpop(key);
    }

    @Override
    public void lpush(String key, String value) {
        this.yuspRedisTemplate.lpush(key, value);
    }

    @Override
    public void rpush(String key, String value) {
        this.yuspRedisTemplate.rpush(key, value);
    }
}

