/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.notification.api;

import cn.com.yusys.yusp.notification.api.INotificationPush;
import cn.com.yusys.yusp.notification.repo.RedisOperation;
import cn.com.yusys.yusp.notification.service.NotificationDbService;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractNotificationPush
implements INotificationPush {
    @Autowired
    protected RedisOperation redisOperation;
    @Autowired
    protected NotificationDbService dbService;

    @Override
    public void subscribe(String consumerId, String topicName) {
        String lastIndex = this.dbService.getTopicIndex(topicName);
        this.dbService.subscribeAppend(consumerId, topicName, lastIndex);
        this.notifyConsumer(consumerId, topicName, "S-");
    }

    @Override
    public void unsubscribe(String consumerId, String topicName) {
        if (!this.dbService.notInnerKey(topicName)) {
            return;
        }
        this.dbService.unSubscribeAppend(consumerId, topicName);
        this.notifyConsumer(consumerId, topicName, "U-");
    }

    @Override
    public void unsubscribe(String consumerId) {
        this.dbService.unSubscribeAppend(consumerId);
        this.notifyConsumer(consumerId, "", "U-");
    }

    private Map<String, Map<String, Integer>> getUnsendNotificationCount(String[] consumerList) {
        HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>(consumerList.length);
        HashMap topicindexCache = new HashMap(16);
        for (String consumerId : consumerList) {
            String subscribeKey = this.dbService.getSubscribeKey(consumerId);
            HashMap<String, Integer> countResult = new HashMap<String, Integer>(16);
            Map<String, String> subscribe = this.redisOperation.getHash(subscribeKey);
            subscribe.remove("--##HOST##--");
            subscribe.forEach((k, v) -> {
                if (v != null) {
                    int sendIndex = Integer.parseInt(v);
                    Integer topicIndex = this.queryTopicIndex((String)k, topicindexCache);
                    if (topicIndex != null) {
                        countResult.put((String)k, topicIndex - sendIndex);
                    }
                }
            });
            countResult.put(consumerId, this.dbService.getSendNotifications(consumerId).size());
            result.put(consumerId, countResult);
        }
        return result;
    }

    private Integer queryTopicIndex(String topicName, Map<String, Integer> topicindexCache) {
        Integer topicIndex = null;
        if (topicindexCache.containsKey(topicName)) {
            topicIndex = topicindexCache.get(topicName);
        } else {
            String strIndex = this.dbService.getTopicIndex(topicName);
            if (strIndex != null) {
                topicIndex = Integer.valueOf(strIndex);
                topicindexCache.put(topicName, topicIndex);
            }
        }
        return topicIndex;
    }

    public Map<String, Integer> getUnsendNotificationCount(String consumerId) {
        Map<String, Map<String, Integer>> result = this.getUnsendNotificationCount(new String[]{consumerId});
        return result.get(consumerId);
    }

    protected void notifyConsumer(String consumerId, String topic, String type) {
        String onlineHost = this.dbService.getOnlineHost(consumerId);
        if (onlineHost != null) {
            StringBuilder sb = new StringBuilder(type);
            sb.append(consumerId);
            if (topic.length() != 0) {
                sb.append("@@@@");
                sb.append(topic);
            }
            this.redisOperation.lpush(this.dbService.getEventListKey(onlineHost), sb.toString());
        }
    }
}

