/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.mapper;

import cn.com.yusys.yusp.commons.base.datachange.DataChangeDto;
import cn.com.yusys.yusp.commons.base.datachange.YuspDataChangeUtil;
import cn.com.yusys.yusp.commons.module.adapter.query.PageQuery;
import cn.com.yusys.yusp.commons.module.adapter.query.QueryModel;
import cn.com.yusys.yusp.commons.mybatisplus.util.MybatisPlusUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Param;

public interface BaseMapper<T>
extends com.baomidou.mybatisplus.core.mapper.BaseMapper<T> {
    default public <E extends IPage<T>> E selectByModel(QueryModel model) {
        Page page = new Page((long)model.getPage(), (long)model.getSize());
        return (E)this.selectPage((IPage)page, MybatisPlusUtils.sortWrapper(MybatisPlusUtils.lambdaQuery(model.getCondition()), model.getSort()));
    }

    default public int deleteByIdEx(Serializable ... keys) {
        return Objects.nonNull(keys) ? this.deleteById((Serializable)(keys.length == 1 ? keys[0] : keys)) : -1;
    }

    default public T selectByIdEx(Serializable ... keys) {
        return (T)(Objects.nonNull(keys) ? this.selectById((Serializable)(keys.length == 1 ? keys[0] : keys)) : null);
    }

    public int deleteOne(@Param(value="et") T var1);

    default public <R, Q extends PageQuery, E extends IPage<R>> E page(Q pageQuery, BiFunction<E, Q, E> mapper) {
        return (E)(Objects.nonNull(mapper) ? (IPage)mapper.apply(MybatisPlusUtils.ofPage(pageQuery), pageQuery) : MybatisPlusUtils.emptyPage());
    }

    default public <Q extends PageQuery, E extends IPage<T>> E page(Q pageQuery) {
        return (E)this.selectPage((IPage)MybatisPlusUtils.ofPage(pageQuery), MybatisPlusUtils.pageQueryWrapper(pageQuery));
    }

    default public int delete(T entity) {
        return this.delete(MybatisPlusUtils.pageQueryWrapper(entity));
    }

    default public int deleteBatchIds(String ids) {
        return this.deleteBatchIds(Arrays.stream(StringUtils.split((String)ids, (String)",")).filter(StringUtils::nonBlank).collect(Collectors.toList()));
    }

    default public int updateByIdWithLog(T entity) {
        QueryWrapper query = new QueryWrapper(entity);
        List results = this.selectList((Wrapper)query);
        int count = this.updateById(entity);
        if (count > 0) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo(entity.getClass());
            String tableName = tableInfo == null ? null : tableInfo.getTableName();
            for (Object t : results) {
                DataChangeDto d = new DataChangeDto();
                d.setTableName(tableName);
                d.setOldObject(t);
                d.setNewObject(entity);
                d.setEntityClass(entity.getClass());
                YuspDataChangeUtil.send((DataChangeDto)d);
            }
        }
        return count;
    }

    default public int updateByIdWhenChange(T entity) {
        int count = 0;
        QueryWrapper query = new QueryWrapper(entity);
        List results = this.selectList((Wrapper)query);
        if (!results.isEmpty() && results.size() == 1) {
            Object valueFromTable = results.get(0);
            if (entity.equals(valueFromTable)) {
                return 0;
            }
            count = this.updateById(entity);
        } else {
            count = this.updateById(entity);
        }
        return count;
    }
}

