/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.injector;

import cn.com.yusys.yusp.commons.mybatisplus.injector.ITableIdExtension;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.ListUtils;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.injector.methods.DeleteById;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteByIdExtension
extends DeleteById
implements ITableIdExtension {
    private static final Logger logger = LoggerFactory.getLogger(DeleteByIdExtension.class);

    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        SqlMethod sqlMethod;
        List exList = this.getTableIdExFields(modelClass, tableInfo);
        if (CommonUtils.isNullOrEmpty((Collection)exList)) {
            return super.injectMappedStatement(mapperClass, modelClass, tableInfo);
        }
        List formatArgs = ListUtils.newArrayList();
        if (tableInfo.isLogicDelete()) {
            sqlMethod = SqlMethod.LOGIC_DELETE_BY_ID;
            formatArgs.add(tableInfo.getTableName());
            formatArgs.add(this.sqlLogicSet(tableInfo));
            formatArgs.add(tableInfo.getKeyColumn());
            formatArgs.add("array[0]");
            formatArgs.add(tableInfo.getLogicDeleteSql(true, true));
        } else {
            sqlMethod = SqlMethod.DELETE_BY_ID;
            formatArgs.add(tableInfo.getTableName());
            formatArgs.add(tableInfo.getKeyColumn());
            formatArgs.add("array[0]");
        }
        String sql = this.appendAndCreateExSql(exList, sqlMethod, formatArgs);
        if (logger.isDebugEnabled()) {
            logger.debug("Model[{}], the registered dynamic sql is:\n{}", (Object)modelClass.getName(), (Object)sql);
        }
        SqlSource sqlSource = this.languageDriver.createSqlSource(this.configuration, sql, Object.class);
        String method = StringUtils.isBlank((CharSequence)this.methodName) ? sqlMethod.getMethod() : this.methodName;
        return tableInfo.isLogicDelete() ? this.addUpdateMappedStatement(mapperClass, modelClass, method, sqlSource) : this.addDeleteMappedStatement(mapperClass, method, sqlSource);
    }
}

